/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.apiext.validation.validators.http;

import com.sap.core.connectivity.apiext.validation.i18n.Messages;
import com.sap.core.connectivity.apiext.validation.utils.CommonUtils;
import com.sap.core.connectivity.apiext.validation.utils.ValidValuesFormatter;
import com.sap.core.connectivity.apiext.validation.validators.Validator;
import com.sap.core.connectivity.apiext.validation.validators.common.BasicPropertiesValidator;
import com.sap.core.connectivity.apiext.validation.validators.http.consts.HttpConstants;
import com.sap.core.connectivity.apiext.validation.violations.Severity;
import com.sap.core.connectivity.apiext.validation.violations.Violation;
import com.sap.core.connectivity.apiext.validation.violations.ViolationSet;
import com.sap.core.connectivity.apiext.validation.violations.ViolationType;
import java.util.Collections;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;

public class AuthenticationValidator
extends Validator {
    private static Set<String> exceptionalCases = new HashSet<String>();
    private boolean initialCheck;

    static {
        Collections.addAll(exceptionalCases, "InternalSystemAuthentication", "OAuth2SAMLBearerAssertion");
    }

    public AuthenticationValidator(boolean initialCheck) {
        this.initialCheck = initialCheck;
    }

    @Override
    public ViolationSet proceedValidation(Properties properties) {
        ViolationSet clientCertAuthViolations;
        String value;
        BasicPropertiesValidator validator = new BasicPropertiesValidator("Authentication", true, ViolationType.AUTHENTICATION_MISSING, false);
        ViolationSet violations = validator.validate(properties);
        if (violations.hasErrors()) {
            return violations;
        }
        String string = value = properties.getProperty("Authentication") == null ? null : properties.getProperty("Authentication").trim();
        if (this.initialCheck) {
            if (!HttpConstants.allowedTypesOfAuthenticationFromIDE.contains(value)) {
                return ViolationSet.createViolationSet(new Violation(ViolationType.AUTHENTICATION_NOT_VALID, Messages.getMessage("NotSupportedAuthenticationTypeFromInitialCheck", new Object[0]), Severity.ERROR));
            }
        } else if (!HttpConstants.allowedTypesOfAuthentication.contains(value) && !exceptionalCases.contains(value)) {
            return ViolationSet.createViolationSet(new Violation(ViolationType.AUTHENTICATION_NOT_VALID, Messages.getMessage("ValueIsNotInAllowedRange", value, "Authentication", ValidValuesFormatter.format(HttpConstants.allowedTypesOfAuthentication)), Severity.ERROR));
        }
        if ((clientCertAuthViolations = this.validateClientCertificateAuthenticationType(properties, value)).hasErrors() || clientCertAuthViolations.hasWarnings()) {
            return clientCertAuthViolations;
        }
        ViolationSet appToAppAuthViolations = this.validateAppToAppAuthenticationType(properties, value);
        if (appToAppAuthViolations.hasErrors() || appToAppAuthViolations.hasWarnings()) {
            return appToAppAuthViolations;
        }
        return this.validatePrincipalPropagation(properties, value);
    }

    private ViolationSet validateClientCertificateAuthenticationType(Properties properties, String value) {
        if ("ClientCertificateAuthentication".equals(value)) {
            String proxyType = properties.getProperty("ProxyType");
            if (proxyType != null && !proxyType.trim().equals("Internet")) {
                return ViolationSet.createViolationSet(new Violation(ViolationType.CLIENT_CERTIFICATE_AUTHENTICATION_INAPPROPRIATE, Messages.getMessage("AuthenticationNotValidInCombinationWith", value, "ProxyType", "Internet"), Severity.ERROR));
            }
            if (!CommonUtils.isSetNonEmptyProperty(properties, "URL")) {
                return ViolationSet.createViolationSet(new Violation(ViolationType.URL_MISSING, Messages.getMessage("UrlMissingNeededToCheckClientCertificateAuthentication", value), CommonUtils.getSeverityAccordingToClient(this.initialCheck)));
            }
            String url = properties.getProperty("URL").trim();
            if (!url.toLowerCase().startsWith("https")) {
                return ViolationSet.createViolationSet(new Violation(ViolationType.CLIENT_CERTIFICATE_AUTHENTICATION_INAPPROPRIATE, Messages.getMessage("UrlWithoutHttpsNeededToCheckClientCertificateAuthentication", new Object[0]), Severity.ERROR));
            }
        }
        return ViolationSet.emptyViolationSet();
    }

    private ViolationSet validateAppToAppAuthenticationType(Properties properties, String authValue) {
        boolean isOnPremise;
        if (!"AppToAppSSO".equals(authValue)) {
            return ViolationSet.emptyViolationSet();
        }
        boolean bl = isOnPremise = properties.containsKey("ProxyType") && properties.getProperty("ProxyType").trim().equals("OnPremise");
        if (isOnPremise) {
            return ViolationSet.createViolationSet(new Violation(ViolationType.APP_TO_APP_INAPPROPRIATE, Messages.getMessage("AuthenticationNotValidInCombinationWith", authValue, "ProxyType", "Internet"), Severity.WARNING));
        }
        return ViolationSet.emptyViolationSet();
    }

    private ViolationSet validatePrincipalPropagation(Properties properties, String authValue) {
        boolean isOnPremise;
        if (!"PrincipalPropagation".equals(authValue)) {
            return ViolationSet.emptyViolationSet();
        }
        boolean bl = isOnPremise = properties.containsKey("ProxyType") && properties.getProperty("ProxyType").trim().equals("OnPremise");
        if (!isOnPremise) {
            return ViolationSet.createViolationSet(new Violation(ViolationType.PRINCIPAL_PROPAGATION_INAPPROPRIATE, Messages.getMessage("AuthenticationNotValidInCombinationWith", authValue, "ProxyType", "OnPremise"), Severity.ERROR));
        }
        return ViolationSet.emptyViolationSet();
    }
}

