/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.apiext.validation.validators.http;

import com.sap.core.connectivity.apiext.validation.i18n.Messages;
import com.sap.core.connectivity.apiext.validation.validators.Validator;
import com.sap.core.connectivity.apiext.validation.validators.http.consts.HttpConstants;
import com.sap.core.connectivity.apiext.validation.violations.Severity;
import com.sap.core.connectivity.apiext.validation.violations.Violation;
import com.sap.core.connectivity.apiext.validation.violations.ViolationSet;
import com.sap.core.connectivity.apiext.validation.violations.ViolationType;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;

class GenericHttpUrlValidator
extends Validator {
    private String propertyName;
    private ViolationType typeMissing;
    private ViolationType typeIncorrectProtocol;
    private ViolationType typeHostMissing;
    private ViolationType typeInvalidSyntax;

    GenericHttpUrlValidator(String propertyName, ViolationType typeMissing, ViolationType typeIncorrectProtocol, ViolationType typeHostMissing, ViolationType typeInvalidSyntax) {
        this.propertyName = propertyName;
        this.typeMissing = typeMissing;
        this.typeIncorrectProtocol = typeIncorrectProtocol;
        this.typeHostMissing = typeHostMissing;
        this.typeInvalidSyntax = typeInvalidSyntax;
    }

    @Override
    public ViolationSet proceedValidation(Properties properties) {
        if (!properties.containsKey(this.propertyName) || properties.getProperty(this.propertyName).trim().isEmpty()) {
            return ViolationSet.createViolationSet(new Violation(this.typeMissing, Messages.getMessage("ValueIsEmptyString", this.propertyName), Severity.ERROR));
        }
        String value = properties.getProperty(this.propertyName).trim();
        return this.validateURL(value);
    }

    private ViolationSet validateURL(String value) {
        try {
            URL url = new URL(value);
            String protocol = url.getProtocol();
            String host = url.getHost();
            if (protocol == null || !HttpConstants.ALLOWED_PROTOCOLS.contains(protocol.toLowerCase())) {
                return ViolationSet.createViolationSet(new Violation(this.typeIncorrectProtocol, Messages.getMessage("InvalidURLProtocolErrorMSG", new Object[0]), Severity.ERROR));
            }
            if (!value.toLowerCase().startsWith(String.valueOf(protocol.toLowerCase()) + "://")) {
                return ViolationSet.createViolationSet(new Violation(this.typeInvalidSyntax, Messages.getMessage("UriNotValid", value), Severity.ERROR));
            }
            if (host == null) {
                return ViolationSet.createViolationSet(new Violation(this.typeHostMissing, Messages.getMessage("InvalidURLHostErrorMSG", value), Severity.ERROR));
            }
        }
        catch (MalformedURLException malformedURLException) {
            return ViolationSet.createViolationSet(new Violation(this.typeIncorrectProtocol, Messages.getMessage("InvalidURLProtocolErrorMSG", new Object[0]), Severity.ERROR));
        }
        return ViolationSet.emptyViolationSet();
    }
}

