/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.apiext.validation.validators.http;

import com.sap.core.connectivity.apiext.validation.i18n.Messages;
import com.sap.core.connectivity.apiext.validation.validators.Validator;
import com.sap.core.connectivity.apiext.validation.violations.Severity;
import com.sap.core.connectivity.apiext.validation.violations.Violation;
import com.sap.core.connectivity.apiext.validation.violations.ViolationSet;
import com.sap.core.connectivity.apiext.validation.violations.ViolationType;
import java.text.MessageFormat;
import java.util.List;
import java.util.Properties;

class GenericOAuth2PropertyValidator
extends Validator {
    protected static final String PROPERTY_REDUNDANT_BECAUSE_OF_ANOTHER_PROPERTY = "PropertyRedundantBecauseOfAnotherProperty";
    protected String propertyName;
    protected ViolationType typeRedundant;
    protected boolean isRequired;
    protected ViolationType typeMissing;
    private List<String> allowedAuthenticationTypes;

    GenericOAuth2PropertyValidator(List<String> allowedAuthenticationTypes, String propertyName, ViolationType typeRedundant) {
        this(allowedAuthenticationTypes, propertyName, false, typeRedundant, null);
    }

    GenericOAuth2PropertyValidator(List<String> allowedAuthenticationTypes, String propertyName, boolean isRequired, ViolationType typeRedundant, ViolationType typeMissing) {
        this.propertyName = propertyName;
        this.isRequired = isRequired;
        this.typeRedundant = typeRedundant;
        this.typeMissing = typeMissing;
        if (allowedAuthenticationTypes == null || allowedAuthenticationTypes.isEmpty()) {
            throw new IllegalArgumentException(MessageFormat.format("No allowed authentication types for property :{0} are passed", propertyName));
        }
        this.allowedAuthenticationTypes = allowedAuthenticationTypes;
        if (isRequired && typeMissing == null) {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public ViolationSet proceedValidation(Properties properties) {
        String authentication;
        String string = authentication = properties.containsKey("Authentication") ? properties.getProperty("Authentication").trim() : null;
        if (authentication == null || !this.allowedAuthenticationTypes.contains(authentication)) {
            if (properties.containsKey(this.propertyName)) {
                return ViolationSet.createViolationSet(new Violation(this.typeRedundant, Messages.getMessage(PROPERTY_REDUNDANT_BECAUSE_OF_ANOTHER_PROPERTY, this.propertyName, "Authentication", this.allowedAuthenticationTypesMessage()), Severity.WARNING));
            }
        } else if (this.isRequired) {
            String propertyValue = properties.getProperty(this.propertyName);
            if (propertyValue == null) {
                return ViolationSet.createViolationSet(new Violation(this.typeMissing, Messages.getMessage("MissingRequiredAuthenticationRelatedProperty", this.allowedAuthenticationTypesMessage(), this.propertyName), Severity.ERROR));
            }
            if (!propertyValue.matches(".*\\S.*")) {
                return ViolationSet.createViolationSet(new Violation(this.typeMissing, Messages.getMessage("ValueIsEmptyString", this.propertyName), Severity.ERROR));
            }
        }
        return ViolationSet.emptyViolationSet();
    }

    private String allowedAuthenticationTypesMessage() {
        if (this.allowedAuthenticationTypes.size() == 1) {
            return this.allowedAuthenticationTypes.get(0);
        }
        return MessageFormat.format("one of the following : {0}", this.allowedAuthenticationTypes);
    }
}

