/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.apiext.validation.validators.http;

import com.sap.core.connectivity.apiext.validation.i18n.Messages;
import com.sap.core.connectivity.apiext.validation.validators.Validator;
import com.sap.core.connectivity.apiext.validation.violations.Severity;
import com.sap.core.connectivity.apiext.validation.violations.Violation;
import com.sap.core.connectivity.apiext.validation.violations.ViolationSet;
import com.sap.core.connectivity.apiext.validation.violations.ViolationType;
import java.util.Properties;

class GenericSAPAssertionSSOPropertyValidator
extends Validator {
    private String propertyName;
    private ViolationType typeMissing;
    private ViolationType typeRedundant;
    private ViolationType typeNotValid;
    private String regex;

    GenericSAPAssertionSSOPropertyValidator(String propertyName, ViolationType typeMissing, ViolationType typeRedundant, ViolationType typeNotValid, String regex) {
        this.propertyName = propertyName;
        this.typeMissing = typeMissing;
        this.typeRedundant = typeRedundant;
        this.typeNotValid = typeNotValid;
        this.regex = regex;
    }

    @Override
    public ViolationSet proceedValidation(Properties properties) {
        if (!properties.containsKey("Authentication") && properties.containsKey(this.propertyName)) {
            return ViolationSet.createViolationSet(new Violation(ViolationType.AUTHENTICATION_MISSING, Messages.getMessage("MandatoryPropertyMissingNeededToCheckAnotherProperty", "Authentication", this.propertyName), Severity.WARNING));
        }
        if (properties.containsKey("Authentication")) {
            String authentication = properties.getProperty("Authentication").trim();
            if (authentication.equals("SAPAssertionSSO")) {
                if (!properties.containsKey(this.propertyName)) {
                    return ViolationSet.createViolationSet(new Violation(this.typeMissing, Messages.getMessage("MissingRequiredAuthenticationRelatedProperty", "SAPAssertionSSO", this.propertyName), Severity.ERROR));
                }
                String propertyValue = properties.getProperty(this.propertyName).trim();
                if (!propertyValue.matches(this.regex)) {
                    String message = null;
                    message = this.propertyName.contains("SID") ? Messages.getMessage("RfcNotValidCharFormat", this.propertyName, 3) : (this.propertyName.contains("Client") ? Messages.getMessage("RfcNotValidFormat", this.propertyName, 3) : Messages.getMessage("SAPAssertionSSORelatedPropertyValidRegEx", this.propertyName));
                    return ViolationSet.createViolationSet(new Violation(this.typeNotValid, message, Severity.ERROR));
                }
            } else if (properties.containsKey(this.propertyName)) {
                return ViolationSet.createViolationSet(new Violation(this.typeRedundant, Messages.getMessage("PropertyRedundantBecauseOfAnotherProperty", this.propertyName, "Authentication", "SAPAssertionSSO"), Severity.WARNING));
            }
        }
        return ViolationSet.emptyViolationSet();
    }
}

