/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.apiext.validation.validators.http;

import com.sap.core.connectivity.apiext.validation.i18n.Messages;
import com.sap.core.connectivity.apiext.validation.utils.ValidValuesFormatter;
import com.sap.core.connectivity.apiext.validation.validators.Validator;
import com.sap.core.connectivity.apiext.validation.validators.http.consts.HttpConstants;
import com.sap.core.connectivity.apiext.validation.violations.Severity;
import com.sap.core.connectivity.apiext.validation.violations.Violation;
import com.sap.core.connectivity.apiext.validation.violations.ViolationSet;
import com.sap.core.connectivity.apiext.validation.violations.ViolationType;
import java.util.Properties;

public class HostnameVerifierValidator
extends Validator {
    @Override
    public ViolationSet proceedValidation(Properties properties) {
        String value;
        if (!properties.containsKey("HostnameVerifier")) {
            return ViolationSet.emptyViolationSet();
        }
        if (properties.containsKey("TrustAll")) {
            String trustAllValue = properties.getProperty("TrustAll").trim();
            boolean trustAll = false;
            if (trustAllValue.toLowerCase().equals("true")) {
                trustAll = true;
            }
            if (trustAll && properties.containsKey("HostnameVerifier")) {
                return ViolationSet.createViolationSet(new Violation(ViolationType.HOSTNAME_VERIFIER_REDUNDANT, Messages.getMessage("TrustAllCausesPropertyRedundant", "HostnameVerifier"), Severity.WARNING));
            }
        }
        if (!HttpConstants.hostnameVerifiersAllowed.contains(value = properties.getProperty("HostnameVerifier").trim())) {
            return ViolationSet.createViolationSet(new Violation(ViolationType.HOSTNAME_VERIFIER_NOT_VALID, Messages.getMessage("ValueIsNotInAllowedRange", value, "HostnameVerifier", ValidValuesFormatter.format(HttpConstants.hostnameVerifiersAllowed)), Severity.ERROR));
        }
        return ViolationSet.emptyViolationSet();
    }
}

