/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.apiext.validation.validators.http;

import com.sap.core.connectivity.apiext.validation.i18n.Messages;
import com.sap.core.connectivity.apiext.validation.validators.Validator;
import com.sap.core.connectivity.apiext.validation.validators.common.FilePathValidator;
import com.sap.core.connectivity.apiext.validation.validators.consts.CommonConstants;
import com.sap.core.connectivity.apiext.validation.validators.http.KeyStoreUtil;
import com.sap.core.connectivity.apiext.validation.violations.Severity;
import com.sap.core.connectivity.apiext.validation.violations.Violation;
import com.sap.core.connectivity.apiext.validation.violations.ViolationSet;
import com.sap.core.connectivity.apiext.validation.violations.ViolationType;
import java.util.Properties;

public class KeyStoreLocationValidator
extends Validator {
    @Override
    public ViolationSet proceedValidation(Properties properties) {
        ViolationSet set;
        boolean keyStoreLocationExists = properties.containsKey("KeyStoreLocation");
        KeyStoreUtil util = new KeyStoreUtil(properties, "KeyStoreLocation", ViolationType.KEY_STORE_LOCATION_REDUNDANT);
        boolean isKeyStoreLocationNeeded = util.isPropertyNeeded();
        ViolationSet violations = util.getViolationsOccurred();
        if (isKeyStoreLocationNeeded && !keyStoreLocationExists) {
            violations.add(new Violation(ViolationType.KEY_STORE_LOCATION_MISSING, Messages.getMessage("PropertyMissing", "KeyStoreLocation"), Severity.ERROR));
            return violations;
        }
        if (isKeyStoreLocationNeeded && keyStoreLocationExists && ((set = this.proceedFilePathValidation(properties)).hasErrors() || set.hasWarnings())) {
            violations.addSet(set);
            return violations;
        }
        return violations;
    }

    public ViolationSet proceedFilePathValidation(Properties properties) {
        FilePathValidator pathValidator = new FilePathValidator("KeyStoreLocation", CommonConstants.allowedKeyStoreExtensions);
        return pathValidator.validate(properties);
    }
}

