/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.apiext.validation.validators.http;

import com.sap.core.connectivity.apiext.validation.i18n.Messages;
import com.sap.core.connectivity.apiext.validation.violations.Severity;
import com.sap.core.connectivity.apiext.validation.violations.Violation;
import com.sap.core.connectivity.apiext.validation.violations.ViolationSet;
import com.sap.core.connectivity.apiext.validation.violations.ViolationType;
import java.util.Properties;

class KeyStoreUtil {
    private boolean isPropertyNeeded = false;
    private ViolationSet violationSet = new ViolationSet();

    boolean isPropertyNeeded() {
        return this.isPropertyNeeded;
    }

    ViolationSet getViolationsOccurred() {
        return this.violationSet;
    }

    KeyStoreUtil(Properties properties, String keyStoreProperty, ViolationType keyStorePropertyRedundant) {
        this.violationSet.addSet(this.preparatoryChecks(properties, keyStoreProperty, keyStorePropertyRedundant));
    }

    private ViolationSet preparatoryChecks(Properties properties, String keyStoreProperty, ViolationType keyStorePropertyRedundant) {
        String proxyType;
        boolean keyStorePropertyExists = properties.containsKey(keyStoreProperty);
        boolean isHttpsUsed = false;
        boolean isProxyTypeInternet = true;
        boolean isAuthenticationClientCertificate = false;
        if (!properties.containsKey("URL")) {
            return ViolationSet.createViolationSet(new Violation(ViolationType.URL_MISSING, Messages.getMessage("MandatoryPropertyMissingNeededToCheckAnotherProperty", "URL", keyStoreProperty), Severity.WARNING));
        }
        if (properties.containsKey("URL")) {
            String url = properties.getProperty("URL").trim();
            if (url.startsWith("https")) {
                isHttpsUsed = true;
            }
            if (!isHttpsUsed && keyStorePropertyExists) {
                return ViolationSet.createViolationSet(new Violation(keyStorePropertyRedundant, Messages.getMessage("PropertyRedundantDueToUrl", keyStoreProperty), Severity.WARNING));
            }
        }
        if ((proxyType = properties.getProperty("ProxyType")) != null && !proxyType.trim().equals("Internet")) {
            isProxyTypeInternet = false;
        }
        if (!isProxyTypeInternet && keyStorePropertyExists) {
            return ViolationSet.createViolationSet(new Violation(keyStorePropertyRedundant, Messages.getMessage("PropertyRedundantBecauseOfAnotherProperty", keyStoreProperty, "ProxyType", "Internet"), Severity.WARNING));
        }
        if (!properties.containsKey("Authentication")) {
            return ViolationSet.createViolationSet(new Violation(ViolationType.AUTHENTICATION_MISSING, Messages.getMessage("MandatoryPropertyMissingNeededToCheckAnotherProperty", "Authentication", keyStoreProperty), Severity.WARNING));
        }
        if (properties.containsKey("Authentication")) {
            String authentication = properties.getProperty("Authentication").trim();
            if (authentication.equals("ClientCertificateAuthentication")) {
                isAuthenticationClientCertificate = true;
            }
            if (!isAuthenticationClientCertificate && keyStorePropertyExists) {
                return ViolationSet.createViolationSet(new Violation(keyStorePropertyRedundant, Messages.getMessage("PropertyRedundantBecauseOfAnotherProperty", keyStoreProperty, "Authentication", "ClientCertificateAuthentication"), Severity.WARNING));
            }
        }
        if (isHttpsUsed && isProxyTypeInternet && isAuthenticationClientCertificate) {
            this.isPropertyNeeded = true;
        }
        return ViolationSet.emptyViolationSet();
    }
}

