/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.apiext.validation.validators.http;

import com.sap.core.connectivity.apiext.validation.i18n.Messages;
import com.sap.core.connectivity.apiext.validation.validators.Validator;
import com.sap.core.connectivity.apiext.validation.violations.Severity;
import com.sap.core.connectivity.apiext.validation.violations.Violation;
import com.sap.core.connectivity.apiext.validation.violations.ViolationSet;
import com.sap.core.connectivity.apiext.validation.violations.ViolationType;
import java.util.Properties;

public class PreemptiveValidator
extends Validator {
    @Override
    public ViolationSet proceedValidation(Properties properties) {
        boolean authenticationExists = properties.containsKey("Authentication");
        if (properties.containsKey("Preemptive")) {
            String value;
            if (!authenticationExists) {
                return ViolationSet.createViolationSet(new Violation(ViolationType.AUTHENTICATION_MISSING, Messages.getMessage("AuthenticationMissingCannotStatePreemptiveRedundant", "Preemptive", "Authentication"), Severity.WARNING));
            }
            String authentication = properties.getProperty("Authentication").trim();
            if (authenticationExists && !authentication.equals("BasicAuthentication")) {
                return ViolationSet.createViolationSet(new Violation(ViolationType.PREEMPTIVE_REDUNDANT, Messages.getMessage("PropertyRedundantBecauseOfAnotherProperty", "Preemptive", "Authentication", "BasicAuthentication"), Severity.WARNING));
            }
            if (authenticationExists && authentication.equals("BasicAuthentication") && !(value = properties.getProperty("Preemptive").trim()).toLowerCase().equals("true") && !value.toLowerCase().equals("false")) {
                return ViolationSet.createViolationSet(new Violation(ViolationType.VALUE_OF_BOOLEAN_PROPERTY_NOT_VALID, Messages.getMessage("BooleanPropertyNotValid", "Preemptive", value), Severity.ERROR));
            }
        }
        return ViolationSet.emptyViolationSet();
    }
}

