/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.apiext.validation.validators.http;

import com.sap.core.connectivity.apiext.validation.i18n.Messages;
import com.sap.core.connectivity.apiext.validation.utils.ValidValuesFormatter;
import com.sap.core.connectivity.apiext.validation.validators.Validator;
import com.sap.core.connectivity.apiext.validation.validators.http.consts.HttpConstants;
import com.sap.core.connectivity.apiext.validation.violations.Severity;
import com.sap.core.connectivity.apiext.validation.violations.Violation;
import com.sap.core.connectivity.apiext.validation.violations.ViolationSet;
import com.sap.core.connectivity.apiext.validation.violations.ViolationType;
import java.util.Properties;

public class ProxyTypeValidator
extends Validator {
    private static final String EXCEPTIONAL_CASE = "Internal";

    @Override
    public ViolationSet proceedValidation(Properties properties) {
        if (!properties.containsKey("ProxyType")) {
            return ViolationSet.emptyViolationSet();
        }
        String value = properties.getProperty("ProxyType").trim();
        if (!HttpConstants.proxyTypesAllowed.contains(value) && !value.equals(EXCEPTIONAL_CASE)) {
            return ViolationSet.createViolationSet(new Violation(ViolationType.PROXY_TYPE_NOT_VALID, Messages.getMessage("ValueIsNotInAllowedRange", value, "ProxyType", ValidValuesFormatter.format(HttpConstants.proxyTypesAllowed)), Severity.ERROR));
        }
        return ViolationSet.emptyViolationSet();
    }
}

