/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.apiext.validation.validators.http;

import com.sap.core.connectivity.apiext.validation.validators.http.GenericHttpUrlValidator;
import com.sap.core.connectivity.apiext.validation.validators.http.GenericOAuth2PropertyValidator;
import com.sap.core.connectivity.apiext.validation.violations.ViolationSet;
import com.sap.core.connectivity.apiext.validation.violations.ViolationType;
import java.util.Arrays;
import java.util.Properties;

public class TokenServiceURLValidator
extends GenericOAuth2PropertyValidator {
    public TokenServiceURLValidator() {
        super(Arrays.asList("OAuth2ClientCredentials", "OAuth2SAMLBearerAssertion"), "tokenServiceURL", true, ViolationType.TOKEN_SERVICE_URL_REDUNDANT, ViolationType.TOKEN_SERVICE_URL_MISSING);
    }

    @Override
    public ViolationSet proceedValidation(Properties properties) {
        ViolationSet violations = super.proceedValidation(properties);
        if (violations.hasErrors() || violations.hasWarnings()) {
            return violations;
        }
        if (properties.containsKey("tokenServiceURL")) {
            GenericHttpUrlValidator genericUrlValidator = new GenericHttpUrlValidator("tokenServiceURL", ViolationType.TOKEN_SERVICE_URL_MISSING, ViolationType.TOKEN_SERVICE_URL_INCORRECT_PROTOCOL, ViolationType.TOKEN_SERVICE_URL_HOST_MISSING, ViolationType.TOKEN_SERVICE_URL_NOT_VALID_SYNTAX);
            return genericUrlValidator.validate(properties);
        }
        return ViolationSet.emptyViolationSet();
    }
}

