/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.apiext.validation.validators.http;

import com.sap.core.connectivity.apiext.validation.i18n.Messages;
import com.sap.core.connectivity.apiext.validation.utils.CommonUtils;
import com.sap.core.connectivity.apiext.validation.validators.Validator;
import com.sap.core.connectivity.apiext.validation.validators.common.BooleanValidator;
import com.sap.core.connectivity.apiext.validation.violations.Severity;
import com.sap.core.connectivity.apiext.validation.violations.Violation;
import com.sap.core.connectivity.apiext.validation.violations.ViolationSet;
import com.sap.core.connectivity.apiext.validation.violations.ViolationType;
import java.util.Properties;

public class TrustAllValidator
extends Validator {
    private boolean initialCheck;

    public TrustAllValidator(boolean initialCheck) {
        this.initialCheck = initialCheck;
    }

    @Override
    protected ViolationSet proceedValidation(Properties properties) {
        ViolationSet violations = new ViolationSet();
        boolean hasSpecifiedURL = CommonUtils.isSetNonEmptyProperty(properties, "URL");
        if (hasSpecifiedURL && properties.getProperty("URL").trim().startsWith("https://")) {
            if (properties.containsKey("TrustAll")) {
                violations.addSet(this.validateTrustAllWithHttpsURL(properties));
            }
        } else if (hasSpecifiedURL && !properties.getProperty("URL").trim().startsWith("https://") && properties.containsKey("TrustAll")) {
            violations.add(new Violation(ViolationType.VALUE_OF_BOOLEAN_PROPERTY_NOT_VALID, Messages.getMessage("IncompatibleTrustAllPropertyWithHttpProtocolErrorMSG", new Object[0]), Severity.ERROR));
        } else if (!hasSpecifiedURL) {
            violations.add(new Violation(ViolationType.URL_MISSING, Messages.getMessage("MandatoryPropertyMissingNeededToCheckAnotherProperty", "URL", "TrustAll = true"), CommonUtils.getSeverityAccordingToClient(this.initialCheck && CommonUtils.isSetNonEmptyProperty(properties, "TrustAll"))));
        }
        return violations;
    }

    private ViolationSet validateTrustAllWithHttpsURL(Properties properties) {
        BooleanValidator boolValidator = new BooleanValidator("TrustAll", false);
        ViolationSet violations = boolValidator.validate(properties);
        if (violations.hasErrors()) {
            return violations;
        }
        String value = properties.getProperty("TrustAll").trim();
        if (value.toLowerCase().equals("true") && properties.containsKey("ProxyType") && properties.getProperty("ProxyType").equals("OnPremise")) {
            return ViolationSet.createViolationSet(new Violation(ViolationType.INCOMPATIBLE_PROXY_TYPE_AND_TRUST_ALL, Messages.getMessage("IncompatiblePropertiesErrorMSG", new Object[0]), Severity.ERROR));
        }
        return ViolationSet.emptyViolationSet();
    }
}

