/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.apiext.validation.validators.http;

import com.sap.core.connectivity.apiext.validation.i18n.Messages;
import com.sap.core.connectivity.apiext.validation.utils.CommonUtils;
import com.sap.core.connectivity.apiext.validation.validators.Validator;
import com.sap.core.connectivity.apiext.validation.validators.http.TrustStoreUtil;
import com.sap.core.connectivity.apiext.validation.violations.Violation;
import com.sap.core.connectivity.apiext.validation.violations.ViolationSet;
import com.sap.core.connectivity.apiext.validation.violations.ViolationType;
import java.util.Properties;

public class TrustStorePasswordValidator
extends Validator {
    private boolean initialCheck;

    public TrustStorePasswordValidator() {
        this(false);
    }

    public TrustStorePasswordValidator(boolean initialCheck) {
        this.initialCheck = initialCheck;
    }

    @Override
    public ViolationSet proceedValidation(Properties properties) {
        boolean trustStorePasswordExists = properties.containsKey("TrustStorePassword");
        TrustStoreUtil util = new TrustStoreUtil(properties, "TrustStorePassword", ViolationType.TRUST_STORE_PASSWORD_REDUNDANT);
        boolean isTrustStorePasswordNeeded = util.isPropertyNeeded();
        ViolationSet violations = util.getViolationsOccurred();
        if (isTrustStorePasswordNeeded && !trustStorePasswordExists) {
            violations.add(new Violation(ViolationType.TRUST_STORE_PASSWORD_MISSING, Messages.getMessage("PropertyMissing", "TrustStorePassword"), CommonUtils.getSeverityAccordingToClient(this.initialCheck)));
        }
        return violations;
    }
}

