/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.apiext.validation.validators.http;

import com.sap.core.connectivity.apiext.validation.i18n.Messages;
import com.sap.core.connectivity.apiext.validation.violations.Severity;
import com.sap.core.connectivity.apiext.validation.violations.Violation;
import com.sap.core.connectivity.apiext.validation.violations.ViolationSet;
import com.sap.core.connectivity.apiext.validation.violations.ViolationType;
import java.util.Properties;

public class TrustStoreUtil {
    boolean isPropertyNeeded = false;
    ViolationSet violationSet = new ViolationSet();

    boolean isPropertyNeeded() {
        return this.isPropertyNeeded;
    }

    ViolationSet getViolationsOccurred() {
        return this.violationSet;
    }

    TrustStoreUtil(Properties properties, String trustStoreProperty, ViolationType trustStorePropertyRedundant) {
        this.violationSet.addSet(this.preparatoryChecks(properties, trustStoreProperty, trustStorePropertyRedundant));
    }

    ViolationSet preparatoryChecks(Properties properties, String trustStoreProperty, ViolationType trustStorePropertyRedundant) {
        String proxyType;
        boolean trustStorePropertyExists = properties.containsKey(trustStoreProperty);
        boolean isHttpsUsed = false;
        boolean isProxyTypeInternet = true;
        boolean trustAll = false;
        if (!properties.containsKey("URL")) {
            return ViolationSet.createViolationSet(new Violation(ViolationType.URL_MISSING, Messages.getMessage("MandatoryPropertyMissingNeededToCheckAnotherProperty", "URL", trustStoreProperty), Severity.WARNING));
        }
        if (properties.containsKey("URL")) {
            String url = properties.getProperty("URL").trim();
            if (url.startsWith("https")) {
                isHttpsUsed = true;
            }
            if (!isHttpsUsed && trustStorePropertyExists) {
                return ViolationSet.createViolationSet(new Violation(trustStorePropertyRedundant, Messages.getMessage("PropertyRedundantDueToUrl", trustStoreProperty), Severity.WARNING));
            }
        }
        if ((proxyType = properties.getProperty("ProxyType")) != null && !proxyType.trim().equals("Internet")) {
            isProxyTypeInternet = false;
        }
        if (!isProxyTypeInternet && trustStorePropertyExists) {
            return ViolationSet.createViolationSet(new Violation(trustStorePropertyRedundant, Messages.getMessage("PropertyRedundantBecauseOfAnotherProperty", trustStoreProperty, "ProxyType", "Internet"), Severity.WARNING));
        }
        if (properties.containsKey("TrustAll")) {
            String trustAllValue = properties.getProperty("TrustAll").trim();
            if (trustAllValue.toLowerCase().equals("true")) {
                trustAll = true;
            }
            if (trustAll && trustStorePropertyExists) {
                return ViolationSet.createViolationSet(new Violation(trustStorePropertyRedundant, Messages.getMessage("TrustAllCausesPropertyRedundant", trustStoreProperty), Severity.WARNING));
            }
        }
        if (isHttpsUsed && isProxyTypeInternet && !trustAll) {
            this.isPropertyNeeded = true;
        }
        return ViolationSet.emptyViolationSet();
    }
}

