/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.apiext.validation.validators.ldap;

import com.sap.core.connectivity.apiext.validation.i18n.Messages;
import com.sap.core.connectivity.apiext.validation.utils.ValidValuesFormatter;
import com.sap.core.connectivity.apiext.validation.validators.Validator;
import com.sap.core.connectivity.apiext.validation.validators.common.BasicPropertiesValidator;
import com.sap.core.connectivity.apiext.validation.validators.composite.CompositeValidator;
import com.sap.core.connectivity.apiext.validation.validators.ldap.consts.LdapConstants;
import com.sap.core.connectivity.apiext.validation.violations.Severity;
import com.sap.core.connectivity.apiext.validation.violations.Violation;
import com.sap.core.connectivity.apiext.validation.violations.ViolationSet;
import com.sap.core.connectivity.apiext.validation.violations.ViolationType;
import java.util.Properties;

public class LdapAuthenticationValidator
extends BasicPropertiesValidator {
    public LdapAuthenticationValidator() {
        super("ldap.authentication", true, ViolationType.AUTHENTICATION_MISSING, false);
    }

    @Override
    public ViolationSet proceedValidation(Properties properties) {
        ViolationSet violations = super.proceedValidation(properties);
        if (violations.hasErrors()) {
            return violations;
        }
        String value = properties.getProperty("ldap.authentication").trim();
        if ("BasicAuthentication".equals(value)) {
            BasicPropertiesValidator passwordValidator = new BasicPropertiesValidator("ldap.password", true, ViolationType.PASSWORD_MISSING, false);
            BasicPropertiesValidator userValidator = new BasicPropertiesValidator("ldap.user", true, ViolationType.USER_MISSING, false);
            CompositeValidator basicAuthValidator = new CompositeValidator(new Validator[]{passwordValidator, userValidator}){};
            return basicAuthValidator.validate(properties);
        }
        if (!"NoAuthentication".equals(value)) {
            return ViolationSet.createViolationSet(new Violation(ViolationType.AUTHENTICATION_NOT_VALID, Messages.getMessage("LdapUnsupportedAuthentication", ValidValuesFormatter.format(LdapConstants.ALLOWED_AUTHN_TYPES)), Severity.ERROR));
        }
        return violations;
    }
}

