/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.apiext.validation.validators.ldap;

import com.sap.core.connectivity.apiext.validation.i18n.Messages;
import com.sap.core.connectivity.apiext.validation.validators.Validator;
import com.sap.core.connectivity.apiext.validation.validators.ldap.consts.LdapConstants;
import com.sap.core.connectivity.apiext.validation.violations.Severity;
import com.sap.core.connectivity.apiext.validation.violations.Violation;
import com.sap.core.connectivity.apiext.validation.violations.ViolationSet;
import com.sap.core.connectivity.apiext.validation.violations.ViolationType;
import java.util.Properties;

public class LdapCalculatedPropertiesValidator
extends Validator {
    @Override
    public ViolationSet proceedValidation(Properties properties) {
        ViolationSet violations = null;
        LdapConstants.DirContextProperty[] dirContextPropertyArray = LdapConstants.DirContextProperty.values();
        int n = dirContextPropertyArray.length;
        int n2 = 0;
        while (n2 < n) {
            LdapConstants.DirContextProperty ldapDirContextProperty = dirContextPropertyArray[n2];
            if (ldapDirContextProperty.isToBeValidated(properties) && properties.getProperty(ldapDirContextProperty.key()) != null) {
                if (violations == null) {
                    violations = new ViolationSet();
                }
                violations.add(new Violation(ViolationType.LDAP_NAMESPACE_COLLISION, Messages.getMessage("LdapNamespaceCollision", ldapDirContextProperty.key()), Severity.ERROR));
            }
            ++n2;
        }
        return violations != null ? violations : ViolationSet.emptyViolationSet();
    }
}

