/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.apiext.validation.validators.ldap;

import com.sap.core.connectivity.apiext.validation.i18n.Messages;
import com.sap.core.connectivity.apiext.validation.validators.common.BasicPropertiesValidator;
import com.sap.core.connectivity.apiext.validation.violations.Severity;
import com.sap.core.connectivity.apiext.validation.violations.Violation;
import com.sap.core.connectivity.apiext.validation.violations.ViolationSet;
import com.sap.core.connectivity.apiext.validation.violations.ViolationType;
import java.util.Properties;
import java.util.StringTokenizer;

public class LdapUrlValidator
extends BasicPropertiesValidator {
    private static final String LDAP_URL_SCHEME = "ldap://";

    public LdapUrlValidator() {
        super("ldap.url", true, ViolationType.URL_MISSING, false);
    }

    @Override
    public ViolationSet proceedValidation(Properties properties) {
        ViolationSet violations = super.proceedValidation(properties);
        if (violations.hasErrors()) {
            return violations;
        }
        String propValue = properties.getProperty("ldap.url");
        StringTokenizer st = new StringTokenizer(propValue, " ", false);
        ViolationSet urlViolations = null;
        while (st.hasMoreElements()) {
            String ldapURL = st.nextToken().trim().toLowerCase();
            if (ldapURL.startsWith(LDAP_URL_SCHEME)) continue;
            if (urlViolations == null) {
                urlViolations = new ViolationSet();
            }
            urlViolations.add(new Violation(ViolationType.LDAP_UNSUPPORTED_URL_PROTOCOL, Messages.getMessage("LdapUnsupportedURLProtocol", new Object[0]), Severity.ERROR));
        }
        return urlViolations != null ? urlViolations : ViolationSet.emptyViolationSet();
    }
}

