/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.apiext.validation.validators.ldap.consts;

import com.sap.core.connectivity.apiext.validation.validators.consts.CommonConstants;
import java.util.Collections;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;

public class LdapConstants
extends CommonConstants
implements com.sap.core.connectivity.api.validation.consts.LdapConstants {
    public static final String LOCATIONID_TEMP_SEPARATOR = "@";
    public static final String LOCATIONID_SEPARATOR = "^";
    public static final Set<String> ALLOWED_PROXY_TYPES = new HashSet<String>(2);
    public static final Set<String> ALLOWED_AUTHN_TYPES = new HashSet<String>(2);
    public static final String MSG_UNSUPPORTED_PROTOCOL = "LdapUnsupportedURLProtocol";
    public static final String MSG_UNSUPPORTED_AUTHENTICATION = "LdapUnsupportedAuthentication";
    public static final String MSG_NAMESPACE_COLLISION = "LdapNamespaceCollision";
    public static final String KEY_CLIENT_SOCKET_FACTORY = "java.naming.ldap.factory.socket";
    public static final String VALUE_CLIENT_SOCKET_FACTORY = "com.sap.core.connectivity.api.ldap.LdapOnPremiseSocketFactory";

    static {
        Collections.addAll(ALLOWED_PROXY_TYPES, "Internet", "OnPremise");
        Collections.addAll(ALLOWED_AUTHN_TYPES, "BasicAuthentication", "NoAuthentication");
    }

    public static enum DirContextProperty {
        INITIAL_CONTEXT_FACTORY("java.naming.factory.initial"),
        CLIENT_SOCKET_FACTORY("java.naming.ldap.factory.socket"),
        PROVIDER_URL("java.naming.provider.url", "ldap.url"),
        SECURITY_PRINCIPAL("java.naming.security.principal", "ldap.user"),
        SECURITY_CREDENTIALS("java.naming.security.credentials", "ldap.password"),
        SECURITY_AUTHENTICATION("java.naming.security.authentication", "ldap.authentication");

        private final String key;
        private final String alias;

        private DirContextProperty(String key) {
            this(key, key);
        }

        private DirContextProperty(String key, String alias) {
            this.key = key;
            this.alias = alias;
        }

        public String key() {
            return this.key;
        }

        public String alias() {
            return this.alias;
        }

        public boolean isMandatory(Properties properties) {
            switch (this) {
                case SECURITY_PRINCIPAL: {
                    return "BasicAuthentication".equals(SECURITY_AUTHENTICATION.destinationValue(properties));
                }
                case SECURITY_CREDENTIALS: {
                    return "BasicAuthentication".equals(SECURITY_AUTHENTICATION.destinationValue(properties));
                }
                case CLIENT_SOCKET_FACTORY: {
                    return "OnPremise".equals(properties.getProperty("ldap.proxyType"));
                }
            }
            return true;
        }

        public boolean isToBeValidated(Properties properties) {
            if (this == INITIAL_CONTEXT_FACTORY) {
                return false;
            }
            return this.isMandatory(properties);
        }

        private String destinationValue(Properties properties) {
            if (this.alias == null || !properties.containsKey(this.alias)) {
                return null;
            }
            return properties.getProperty(this.alias);
        }

        public String calculateDirContextValue(Properties properties) {
            switch (this) {
                case INITIAL_CONTEXT_FACTORY: {
                    return "com.sun.jndi.ldap.LdapCtxFactory";
                }
                case CLIENT_SOCKET_FACTORY: {
                    return LdapConstants.VALUE_CLIENT_SOCKET_FACTORY;
                }
                case SECURITY_AUTHENTICATION: {
                    return "BasicAuthentication".equals(SECURITY_AUTHENTICATION.destinationValue(properties)) ? "simple" : "none";
                }
            }
            return this.destinationValue(properties);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(this.name());
            sb.append("[key='").append(this.key).append('\'');
            sb.append(", alias='").append(this.alias).append('\'');
            sb.append(']');
            return sb.toString();
        }
    }
}

