/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.apiext.validation.validators.rfc;

import com.sap.core.connectivity.apiext.validation.i18n.Messages;
import com.sap.core.connectivity.apiext.validation.validators.common.BasicPropertiesValidator;
import com.sap.core.connectivity.apiext.validation.violations.Severity;
import com.sap.core.connectivity.apiext.validation.violations.Violation;
import com.sap.core.connectivity.apiext.validation.violations.ViolationSet;
import com.sap.core.connectivity.apiext.validation.violations.ViolationType;
import java.util.Properties;

public class RfcClientValidator
extends BasicPropertiesValidator {
    public RfcClientValidator() {
        super("jco.client.client", true, ViolationType.RFC_MISSING_PARAMETER, false);
    }

    @Override
    protected ViolationSet proceedValidation(Properties properties) {
        ViolationSet violations = super.proceedValidation(properties);
        if (violations.hasErrors()) {
            return violations;
        }
        String clientValue = properties.getProperty("jco.client.client").trim();
        if (!clientValue.matches("\\d{3}")) {
            return ViolationSet.createViolationSet(new Violation(ViolationType.RFC_CLIENT_VALUE_NOT_VALID, Messages.getMessage("RfcNotValidFormat", "jco.client.client", 3), Severity.ERROR));
        }
        return violations;
    }
}

