/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.apiext.validation.validators.rfc;

import com.sap.core.connectivity.apiext.validation.i18n.Messages;
import com.sap.core.connectivity.apiext.validation.validators.common.BasicPropertiesValidator;
import com.sap.core.connectivity.apiext.validation.violations.Severity;
import com.sap.core.connectivity.apiext.validation.violations.Violation;
import com.sap.core.connectivity.apiext.validation.violations.ViolationSet;
import com.sap.core.connectivity.apiext.validation.violations.ViolationType;
import java.util.Properties;

public class RfcMessageServerHostValidator
extends BasicPropertiesValidator {
    public RfcMessageServerHostValidator() {
        super("jco.client.mshost", false, ViolationType.RFC_MISSING_PARAMETER, false);
    }

    @Override
    protected ViolationSet proceedValidation(Properties properties) {
        if (properties.containsKey("jco.client.mshost") && !properties.containsKey("jco.client.ashost")) {
            ViolationSet violations = super.proceedValidation(properties);
            if (violations.hasErrors()) {
                return violations;
            }
            boolean isR3nameSet = properties.containsKey("jco.client.r3name");
            boolean isMsserverSet = properties.containsKey("jco.client.msserv");
            if (isR3nameSet && isMsserverSet) {
                return ViolationSet.createViolationSet(new Violation(ViolationType.RFC_MSSERV_PORT_REDUNDANT, Messages.getMessage("TwoPropertiesSpecifiedAtSameTime", "jco.client.r3name", "jco.client.msserv"), Severity.WARNING));
            }
            if (!isR3nameSet && !isMsserverSet) {
                return ViolationSet.createViolationSet(new Violation(ViolationType.RFC_MSSERV_PORT_MISSING, Messages.getMessage("NoPropertyIsSpecify", "jco.client.r3name", "jco.client.msserv"), Severity.ERROR));
            }
        }
        return ViolationSet.emptyViolationSet();
    }
}

