/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.apiext.validation.validators.rfc;

import com.sap.core.connectivity.apiext.validation.i18n.Messages;
import com.sap.core.connectivity.apiext.validation.validators.common.BasicPropertiesValidator;
import com.sap.core.connectivity.apiext.validation.violations.Severity;
import com.sap.core.connectivity.apiext.validation.violations.Violation;
import com.sap.core.connectivity.apiext.validation.violations.ViolationSet;
import com.sap.core.connectivity.apiext.validation.violations.ViolationType;
import java.util.Properties;

public class RfcMessageServerNameValidator
extends BasicPropertiesValidator {
    public RfcMessageServerNameValidator() {
        super("jco.client.r3name", false, ViolationType.RFC_MISSING_PARAMETER, false);
    }

    @Override
    protected ViolationSet proceedValidation(Properties properties) {
        if (properties.containsKey("jco.client.mshost") && properties.containsKey("jco.client.r3name")) {
            ViolationSet violations = super.proceedValidation(properties);
            if (violations.hasErrors()) {
                return violations;
            }
            String value = properties.getProperty("jco.client.r3name").trim();
            if (!value.matches("[a-zA-Z][a-zA-Z0-9]{2}")) {
                return ViolationSet.createViolationSet(new Violation(ViolationType.RFC_R3NAME_VALUE_NOT_VALID, Messages.getMessage("RfcNotValidCharFormat", "jco.client.r3name", 3), Severity.ERROR));
            }
        }
        return ViolationSet.emptyViolationSet();
    }
}

