/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.apiext.validation.validators.rfc;

import com.sap.core.connectivity.apiext.validation.i18n.Messages;
import com.sap.core.connectivity.apiext.validation.validators.common.BasicPropertiesValidator;
import com.sap.core.connectivity.apiext.validation.validators.rfc.consts.RfcConstants;
import com.sap.core.connectivity.apiext.validation.violations.Severity;
import com.sap.core.connectivity.apiext.validation.violations.Violation;
import com.sap.core.connectivity.apiext.validation.violations.ViolationSet;
import com.sap.core.connectivity.apiext.validation.violations.ViolationType;
import java.util.Properties;

public class RfcPasswordValidator
extends BasicPropertiesValidator {
    public RfcPasswordValidator() {
        super("jco.client.passwd", true, ViolationType.RFC_MISSING_PARAMETER, false);
    }

    @Override
    protected ViolationSet proceedValidation(Properties properties) {
        if (!properties.containsKey("jco.client.user")) {
            return ViolationSet.emptyViolationSet();
        }
        ViolationSet violations = super.proceedValidation(properties);
        if (violations.hasErrors()) {
            return violations;
        }
        String passValue = properties.getProperty("jco.client.passwd");
        if (passValue.length() > RfcConstants.MAX_RFC_PASSWD_LENGTH) {
            return ViolationSet.createViolationSet(new Violation(ViolationType.RFC_TOO_LONG_PASS, Messages.getMessage("RfcPasswdTooLong", "jco.client.passwd"), Severity.ERROR));
        }
        return ViolationSet.emptyViolationSet();
    }
}

