/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.apiext.validation.validators.rfc;

import com.sap.core.connectivity.apiext.validation.i18n.Messages;
import com.sap.core.connectivity.apiext.validation.validators.common.BasicPropertiesValidator;
import com.sap.core.connectivity.apiext.validation.violations.Severity;
import com.sap.core.connectivity.apiext.validation.violations.Violation;
import com.sap.core.connectivity.apiext.validation.violations.ViolationSet;
import com.sap.core.connectivity.apiext.validation.violations.ViolationType;
import java.util.Properties;

public class RfcSystemNumberValidator
extends BasicPropertiesValidator {
    public RfcSystemNumberValidator() {
        super("jco.client.sysnr", true, ViolationType.RFC_MISSING_PARAMETER, false);
    }

    @Override
    protected ViolationSet proceedValidation(Properties properties) {
        if (properties.containsKey("jco.client.ashost")) {
            ViolationSet violations = super.proceedValidation(properties);
            if (violations.hasErrors()) {
                return violations;
            }
            String value = properties.getProperty("jco.client.sysnr").trim();
            if (!value.matches("\\d{2}")) {
                return ViolationSet.createViolationSet(new Violation(ViolationType.RFC_SYSNR_VALUE_NOT_VALID_FORMAT, Messages.getMessage("RfcNotValidFormat", "jco.client.sysnr", 2), Severity.ERROR));
            }
        }
        return ViolationSet.emptyViolationSet();
    }
}

