/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.apiext.validation.validators.rfc;

import com.sap.core.connectivity.apiext.validation.i18n.Messages;
import com.sap.core.connectivity.apiext.validation.validators.Validator;
import com.sap.core.connectivity.apiext.validation.violations.Severity;
import com.sap.core.connectivity.apiext.validation.violations.Violation;
import com.sap.core.connectivity.apiext.validation.violations.ViolationSet;
import com.sap.core.connectivity.apiext.validation.violations.ViolationType;
import java.util.Properties;

public class RfcTargetHostValidator
extends Validator {
    @Override
    protected ViolationSet proceedValidation(Properties properties) {
        boolean isAsHostSet = properties.containsKey("jco.client.ashost");
        boolean isMsHostSet = properties.containsKey("jco.client.mshost");
        if (!isAsHostSet && !isMsHostSet) {
            return ViolationSet.createViolationSet(new Violation(ViolationType.RFC_TARGET_HOST_MISSING, Messages.getMessage("NoPropertyIsSpecify", "jco.client.ashost", "jco.client.mshost"), Severity.ERROR));
        }
        if (isAsHostSet && isMsHostSet) {
            return ViolationSet.createViolationSet(new Violation(ViolationType.RFC_TARGET_HOST_MISSING, Messages.getMessage("TwoPropertiesSpecifiedAtSameTime", "jco.client.ashost", "jco.client.mshost"), Severity.ERROR));
        }
        return ViolationSet.emptyViolationSet();
    }
}

