/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.apiext.validation.validators.rfc.optionalProperties;

import com.sap.core.connectivity.apiext.validation.i18n.Messages;
import com.sap.core.connectivity.apiext.validation.validators.Validator;
import com.sap.core.connectivity.apiext.validation.validators.common.BasicPropertiesValidator;
import com.sap.core.connectivity.apiext.validation.violations.Severity;
import com.sap.core.connectivity.apiext.validation.violations.Violation;
import com.sap.core.connectivity.apiext.validation.violations.ViolationSet;
import com.sap.core.connectivity.apiext.validation.violations.ViolationType;
import java.util.Properties;

public class PositiveIntegerHelperValidator
extends Validator {
    private String key;

    public PositiveIntegerHelperValidator(String key) {
        if (key == null) {
            throw new IllegalArgumentException("Parameter key cannot be null");
        }
        this.key = key;
    }

    @Override
    protected ViolationSet proceedValidation(Properties properties) {
        BasicPropertiesValidator basicValidator = new BasicPropertiesValidator(this.key, false, ViolationType.RFC_MISSING_PARAMETER, false);
        ViolationSet violations = basicValidator.validate(properties);
        if (violations.hasErrors()) {
            return violations;
        }
        if (!properties.containsKey(this.key)) {
            return violations;
        }
        String value = properties.getProperty(this.key).trim();
        if (!value.matches("(0|[1-9][0-9]*)")) {
            ViolationSet additionalViolations = ViolationSet.createViolationSet(new Violation(ViolationType.RFC_POOLING_PROPERTY_DOES_NOT_MATCH_REGEX, Messages.getMessage("RfcOptionalPositiveIntegerPropertyNotValid", this.key), Severity.ERROR));
            additionalViolations.addSet(violations);
            return additionalViolations;
        }
        return violations;
    }
}

