/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.apiext.validation.validators.rfc.optionalProperties;

import com.sap.core.connectivity.apiext.validation.i18n.Messages;
import com.sap.core.connectivity.apiext.validation.validators.common.BasicPropertiesValidator;
import com.sap.core.connectivity.apiext.validation.violations.Severity;
import com.sap.core.connectivity.apiext.validation.violations.Violation;
import com.sap.core.connectivity.apiext.validation.violations.ViolationSet;
import com.sap.core.connectivity.apiext.validation.violations.ViolationType;
import java.util.Properties;

public class RfcClientCodePageValidator
extends BasicPropertiesValidator {
    public RfcClientCodePageValidator() {
        super("jco.client.codepage", false, ViolationType.RFC_MISSING_PARAMETER, false);
    }

    @Override
    protected ViolationSet proceedValidation(Properties properties) {
        ViolationSet violations = super.proceedValidation(properties);
        if (violations.hasErrors()) {
            return violations;
        }
        if (!properties.containsKey("jco.client.codepage")) {
            return violations;
        }
        String value = properties.getProperty("jco.client.codepage").trim();
        if (!value.matches("[0-9]{4}")) {
            ViolationSet additionalViolations = ViolationSet.createViolationSet(new Violation(ViolationType.RFC_CODEPAGE_DOES_NOT_MATCH_REGEX, Messages.getMessage("RfcNotValidFormat", "jco.client.codepage", 4), Severity.ERROR));
            additionalViolations.addSet(violations);
            return additionalViolations;
        }
        return violations;
    }
}

