/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.apiext.validation.validators.rfc.optionalProperties;

import com.sap.core.connectivity.apiext.validation.i18n.Messages;
import com.sap.core.connectivity.apiext.validation.validators.common.BasicPropertiesValidator;
import com.sap.core.connectivity.apiext.validation.violations.Severity;
import com.sap.core.connectivity.apiext.validation.violations.Violation;
import com.sap.core.connectivity.apiext.validation.violations.ViolationSet;
import com.sap.core.connectivity.apiext.validation.violations.ViolationType;
import java.util.Properties;

public class RfcClientLangValidator
extends BasicPropertiesValidator {
    public RfcClientLangValidator() {
        super("jco.client.lang", false, ViolationType.RFC_MISSING_PARAMETER, false);
    }

    @Override
    protected ViolationSet proceedValidation(Properties properties) {
        ViolationSet violations = super.proceedValidation(properties);
        if (violations.hasErrors()) {
            return violations;
        }
        if (!properties.containsKey("jco.client.lang")) {
            return violations;
        }
        String value = properties.getProperty("jco.client.lang").trim();
        boolean matchesFirstFormat = value.matches("[a-zA-Z]{2}");
        boolean matchesSecondFormat = value.matches("[a-zA-Z0-9]");
        if (!matchesFirstFormat && !matchesSecondFormat) {
            return ViolationSet.createViolationSet(new Violation(ViolationType.RFC_LANG_NOT_VALID, Messages.getMessage("RfcLangNotValidFormat", "jco.client.lang", 2, 1), Severity.ERROR));
        }
        return ViolationSet.emptyViolationSet();
    }
}

