/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.apiext.validation.validators.rfc.optionalProperties;

import com.sap.core.connectivity.apiext.validation.i18n.Messages;
import com.sap.core.connectivity.apiext.validation.validators.common.BasicPropertiesValidator;
import com.sap.core.connectivity.apiext.validation.validators.rfc.consts.RfcConstants;
import com.sap.core.connectivity.apiext.validation.violations.Severity;
import com.sap.core.connectivity.apiext.validation.violations.Violation;
import com.sap.core.connectivity.apiext.validation.violations.ViolationSet;
import com.sap.core.connectivity.apiext.validation.violations.ViolationType;
import java.util.Properties;

public class RfcRepositoryPasswdValidator
extends BasicPropertiesValidator {
    public RfcRepositoryPasswdValidator() {
        super("jco.destination.repository.passwd", true, ViolationType.RFC_MISSING_PARAMETER, false);
    }

    @Override
    protected ViolationSet proceedValidation(Properties properties) {
        if (properties.containsKey("jco.destination.repository.user")) {
            ViolationSet violations = super.proceedValidation(properties);
            if (violations.hasErrors()) {
                return violations;
            }
            String value = properties.getProperty("jco.destination.repository.passwd");
            if (value.length() > RfcConstants.MAX_RFC_PASSWD_LENGTH) {
                return ViolationSet.createViolationSet(new Violation(ViolationType.RFC_TOO_LONG_PASS, Messages.getMessage("RfcPasswdTooLong", "jco.destination.repository.passwd"), Severity.ERROR));
            }
            return ViolationSet.emptyViolationSet();
        }
        if (properties.containsKey("jco.destination.repository.passwd")) {
            return ViolationSet.createViolationSet(new Violation(ViolationType.RFC_REPOSITORY_PASSWD_REDUNDANT, Messages.getMessage("PropertyRedundant", "jco.destination.repository.passwd"), Severity.WARNING));
        }
        return ViolationSet.emptyViolationSet();
    }
}

