/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.server.csi;

import com.sap.security.core.server.csi.IXSSEncoder;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URLEncoder;
import java.util.Locale;

public final class XSSEncoder {
    private static final char EMODE_ORG = '\u0000';
    private static final char EMODE_CONSTANT = '\u0001';
    private static final char EMODE_XX = '\u0002';
    private static final char EMODE_XXXX = '\u0003';
    private static final char ECONST_FFFFD = '\u0000';
    private static final char ECONST_QUOT = '\u0001';
    private static final char ECONST_AMP = '\u0002';
    private static final char ECONST_LT = '\u0003';
    private static final char ECONST_GT = '\u0004';
    private static final char ECONST_X9 = '\u0005';
    private static final char ECONST_XA = '\u0006';
    private static final char ECONST_XD = '\u0007';
    private static final char[][] ml_const = new char[][]{{'&', '#', 'x', 'f', 'f', 'f', 'd', ';'}, {'&', 'q', 'u', 'o', 't', ';'}, {'&', 'a', 'm', 'p', ';'}, {'&', 'l', 't', ';'}, {'&', 'g', 't', ';'}, {'&', '#', 'x', '9', ';'}, {'&', '#', 'x', 'a', ';'}, {'&', '#', 'x', 'd', ';'}};
    private static final int[][] ECONST_LENGTH = new int[][]{{0, 8, 6, 8}, {0, 0, 4, 6}, {0, 0, 6, 9}, {0, 0, 4, 6}};
    private static final char[] EHEX_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final char[][] RULE_XX_PREFIX = new char[][]{{'&', '#', 'x'}, {'\\', 'x'}, {'%'}, {'\\'}};
    private static final char[][] RULE_XXXX_PREFIX = new char[][]{{'&', '#', 'x'}, {'\\', 'u'}, {'%'}, {'\\'}};
    private static final char RULE_SUFFIX = ';';
    private static final char RULE_SPACE = ' ';
    private static final char[] FCONST = new char[]{'\u0001', '\u0000'};
    private static final char[] CC_ORG = new char[]{'\u0000', '\u0000'};
    private static final char[] XX_ORG = new char[]{'\u0002', '\u0000'};
    private static final char[][][] enc_rules = new char[][][]{new char[][]{FCONST, FCONST, FCONST, FCONST, FCONST, FCONST, FCONST, FCONST, FCONST, {'\u0001', '\u0005'}, {'\u0001', '\u0006'}, FCONST, FCONST, {'\u0001', '\u0007'}, FCONST, FCONST, FCONST, FCONST, FCONST, FCONST, FCONST, FCONST, FCONST, FCONST, FCONST, FCONST, FCONST, FCONST, FCONST, FCONST, FCONST, FCONST, XX_ORG, XX_ORG, {'\u0001', '\u0001'}, XX_ORG, XX_ORG, XX_ORG, {'\u0001', '\u0002'}, XX_ORG, XX_ORG, XX_ORG, XX_ORG, XX_ORG, CC_ORG, CC_ORG, CC_ORG, XX_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, XX_ORG, XX_ORG, {'\u0001', '\u0003'}, XX_ORG, {'\u0001', '\u0004'}, XX_ORG, XX_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, XX_ORG, XX_ORG, XX_ORG, XX_ORG, CC_ORG, XX_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, XX_ORG, XX_ORG, XX_ORG, XX_ORG, FCONST}, new char[][]{XX_ORG, XX_ORG, XX_ORG, XX_ORG, XX_ORG, XX_ORG, XX_ORG, XX_ORG, XX_ORG, XX_ORG, XX_ORG, XX_ORG, XX_ORG, XX_ORG, XX_ORG, XX_ORG, XX_ORG, XX_ORG, XX_ORG, XX_ORG, XX_ORG, XX_ORG, XX_ORG, XX_ORG, XX_ORG, XX_ORG, XX_ORG, XX_ORG, XX_ORG, XX_ORG, XX_ORG, XX_ORG, XX_ORG, XX_ORG, XX_ORG, XX_ORG, XX_ORG, XX_ORG, XX_ORG, XX_ORG, XX_ORG, XX_ORG, XX_ORG, XX_ORG, CC_ORG, XX_ORG, CC_ORG, XX_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, XX_ORG, XX_ORG, XX_ORG, XX_ORG, XX_ORG, XX_ORG, XX_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, XX_ORG, XX_ORG, XX_ORG, XX_ORG, CC_ORG, XX_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, XX_ORG, XX_ORG, XX_ORG, XX_ORG, XX_ORG}, new char[][]{XX_ORG, XX_ORG, XX_ORG, XX_ORG, XX_ORG, XX_ORG, XX_ORG, XX_ORG, XX_ORG, XX_ORG, XX_ORG, XX_ORG, XX_ORG, XX_ORG, XX_ORG, XX_ORG, XX_ORG, XX_ORG, XX_ORG, XX_ORG, XX_ORG, XX_ORG, XX_ORG, XX_ORG, XX_ORG, XX_ORG, XX_ORG, XX_ORG, XX_ORG, XX_ORG, XX_ORG, XX_ORG, XX_ORG, XX_ORG, XX_ORG, XX_ORG, XX_ORG, XX_ORG, XX_ORG, XX_ORG, XX_ORG, XX_ORG, CC_ORG, XX_ORG, XX_ORG, CC_ORG, CC_ORG, XX_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, XX_ORG, XX_ORG, XX_ORG, XX_ORG, XX_ORG, XX_ORG, XX_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, XX_ORG, XX_ORG, XX_ORG, XX_ORG, CC_ORG, XX_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, XX_ORG, XX_ORG, XX_ORG, XX_ORG, XX_ORG}, new char[][]{XX_ORG, XX_ORG, XX_ORG, XX_ORG, XX_ORG, XX_ORG, XX_ORG, XX_ORG, XX_ORG, XX_ORG, XX_ORG, XX_ORG, XX_ORG, XX_ORG, XX_ORG, XX_ORG, XX_ORG, XX_ORG, XX_ORG, XX_ORG, XX_ORG, XX_ORG, XX_ORG, XX_ORG, XX_ORG, XX_ORG, XX_ORG, XX_ORG, XX_ORG, XX_ORG, XX_ORG, XX_ORG, XX_ORG, XX_ORG, XX_ORG, XX_ORG, XX_ORG, XX_ORG, XX_ORG, XX_ORG, XX_ORG, XX_ORG, XX_ORG, XX_ORG, XX_ORG, XX_ORG, XX_ORG, XX_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, XX_ORG, XX_ORG, XX_ORG, XX_ORG, XX_ORG, XX_ORG, XX_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, XX_ORG, XX_ORG, XX_ORG, XX_ORG, XX_ORG, XX_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, CC_ORG, XX_ORG, XX_ORG, XX_ORG, XX_ORG, XX_ORG}};
    private static IXSSEncoder inst_EncodeAllAboveFF = null;
    private static IXSSEncoder inst_EncodeNotAboveFF = null;

    private static int needEncoding(char c, char type, boolean aboveFF) throws UnsupportedEncodingException {
        if (c < '\u0000') {
            throw new UnsupportedEncodingException("Invalid negative charater in CharSequence");
        }
        if (c < '\u007f') {
            switch (enc_rules[type][c][0]) {
                case '\u0000': {
                    return 0;
                }
                case '\u0001': {
                    return ml_const[enc_rules[type][c][1]].length;
                }
                case '\u0002': {
                    return ECONST_LENGTH[type][2];
                }
                case '\u0003': {
                    return ECONST_LENGTH[type][3];
                }
            }
        } else {
            if (type == '\u0000' && c < '\u00a0') {
                return ECONST_LENGTH[0][1];
            }
            if (c < '\u0100') {
                return ECONST_LENGTH[type][2];
            }
            if (c > '\uffff') {
                throw new UnsupportedEncodingException("Charater is out of its range");
            }
            if (aboveFF || c == '\u2028' || c == '\u2029' || type == '\u0002') {
                return ECONST_LENGTH[type][3];
            }
            return 0;
        }
        return 8;
    }

    private static boolean isNextHex(CharSequence input, int offset) {
        int next = offset + 1;
        if (input == null || input.length() == 0 || input.length() < next) {
            return false;
        }
        if (input.length() == next) {
            return true;
        }
        char c = input.charAt(next);
        return c >= '0' && c <= '9' || c >= 'A' && c <= 'F' || c >= 'a' && c <= 'f';
    }

    private static char[] getHex(char input) {
        char[] chex = input < '\u0100' ? new char[]{EHEX_CHARS[(input & 0xF0) >> 4], EHEX_CHARS[input & 0xF]} : (input < '\u1000' ? new char[]{EHEX_CHARS[input >> 8 & 0xFF & 0xF], EHEX_CHARS[(input & 0xFF & 0xF0) >> 4], EHEX_CHARS[input & 0xFF & 0xF]} : new char[]{EHEX_CHARS[(input >> 8 & 0xFF & 0xF0) >> 4], EHEX_CHARS[input >> 8 & 0xFF & 0xF], EHEX_CHARS[(input & 0xFF & 0xF0) >> 4], EHEX_CHARS[input & 0xFF & 0xF]});
        return chex;
    }

    private static void appendHex(StringBuffer sb, char input) {
        if (input < '\u0100') {
            sb.append(EHEX_CHARS[(input & 0xF0) >> 4]);
            sb.append(EHEX_CHARS[input & 0xF]);
        } else if (input < '\u1000') {
            sb.append(EHEX_CHARS[input >> 8 & 0xFF & 0xF]);
            sb.append(EHEX_CHARS[(input & 0xFF & 0xF0) >> 4]);
            sb.append(EHEX_CHARS[input & 0xFF & 0xF]);
        } else {
            sb.append(EHEX_CHARS[(input >> 8 & 0xFF & 0xF0) >> 4]);
            sb.append(EHEX_CHARS[input >> 8 & 0xFF & 0xF]);
            sb.append(EHEX_CHARS[(input & 0xFF & 0xF0) >> 4]);
            sb.append(EHEX_CHARS[input & 0xFF & 0xF]);
        }
    }

    private static char[] getHex4B(char input) {
        char[] chex = new char[]{EHEX_CHARS[(input >> 8 & 0xFF & 0xF0) >> 4], EHEX_CHARS[input >> 8 & 0xFF & 0xF], EHEX_CHARS[(input & 0xFF & 0xF0) >> 4], EHEX_CHARS[input & 0xFF & 0xF]};
        return chex;
    }

    private static void appendHex4B(StringBuffer sb, char input) {
        sb.append(EHEX_CHARS[(input >> 8 & 0xFF & 0xF0) >> 4]);
        sb.append(EHEX_CHARS[input >> 8 & 0xFF & 0xF]);
        sb.append(EHEX_CHARS[(input & 0xFF & 0xF0) >> 4]);
        sb.append(EHEX_CHARS[input & 0xFF & 0xF]);
    }

    private static void appendEncoded(StringBuffer sb, CharSequence input, int offset, char type, boolean aboveFF) throws UnsupportedEncodingException {
        char c = input.charAt(offset);
        if (c < '\u007f') {
            switch (enc_rules[type][c][0]) {
                case '\u0000': {
                    sb.append(c);
                    return;
                }
                case '\u0001': {
                    sb.append(ml_const[enc_rules[type][c][1]]);
                    return;
                }
                case '\u0002': 
                case '\u0003': {
                    switch (type) {
                        case '\u0000': {
                            sb.append(RULE_XX_PREFIX[0]);
                            XSSEncoder.appendHex(sb, c);
                            sb.append(';');
                            break;
                        }
                        case '\u0001': 
                        case '\u0002': {
                            sb.append(RULE_XX_PREFIX[type]);
                            XSSEncoder.appendHex(sb, c);
                            break;
                        }
                        case '\u0003': {
                            sb.append(RULE_XX_PREFIX[type]);
                            XSSEncoder.appendHex(sb, c);
                            if (!XSSEncoder.isNextHex(input, offset)) break;
                            sb.append(' ');
                            break;
                        }
                    }
                    return;
                }
            }
        } else {
            switch (type) {
                case '\u0000': {
                    if (c < '\u00a0') {
                        sb.append(ml_const[0]);
                        return;
                    }
                    if (c < '\u0100') {
                        sb.append(RULE_XX_PREFIX[0]);
                        XSSEncoder.appendHex(sb, c);
                        sb.append(';');
                    } else if (aboveFF || c == '\u2028' || c == '\u2029') {
                        sb.append(RULE_XXXX_PREFIX[0]);
                        XSSEncoder.appendHex(sb, c);
                        sb.append(';');
                    } else {
                        sb.append(c);
                    }
                    return;
                }
                case '\u0001': {
                    if (c < '\u0100') {
                        sb.append(RULE_XX_PREFIX[1]);
                        XSSEncoder.appendHex(sb, c);
                    } else if (aboveFF || c == '\u2028' || c == '\u2029') {
                        sb.append(RULE_XXXX_PREFIX[1]);
                        XSSEncoder.appendHex4B(sb, c);
                    } else {
                        sb.append(c);
                    }
                    return;
                }
                case '\u0002': {
                    char[] url = new char[]{c};
                    sb.append(URLEncoder.encode(new String(url), "UTF-8").toLowerCase(Locale.ENGLISH));
                    return;
                }
                case '\u0003': {
                    if (c < '\u0100') {
                        sb.append(RULE_XX_PREFIX[3]);
                        XSSEncoder.appendHex(sb, c);
                    } else if (aboveFF || c == '\u2028' || c == '\u2029') {
                        sb.append(RULE_XXXX_PREFIX[3]);
                        XSSEncoder.appendHex(sb, c);
                    } else {
                        sb.append(c);
                        return;
                    }
                    if (XSSEncoder.isNextHex(input, offset)) {
                        sb.append(' ');
                    }
                    return;
                }
            }
        }
    }

    public static CharSequence encode(CharSequence input, int length, char type, boolean encodeAllAbove0xFF) throws UnsupportedEncodingException {
        int i;
        if (input == null) {
            return null;
        }
        int _length = length < 0 ? input.length() : length;
        int len = 0;
        int idx = -1;
        boolean ok = true;
        for (i = 0; i < _length; ++i) {
            int esc = XSSEncoder.needEncoding(input.charAt(i), type, encodeAllAbove0xFF);
            if (esc != 0) {
                ok = false;
                if (idx == -1) {
                    idx = len;
                }
                len += esc;
                continue;
            }
            ++len;
        }
        if (ok) {
            return input;
        }
        StringBuffer buffer = new StringBuffer(len + 16);
        for (i = 0; i < idx; ++i) {
            buffer.append(input.charAt(i));
        }
        for (i = idx; i < _length; ++i) {
            XSSEncoder.appendEncoded(buffer, input, i, type, encodeAllAbove0xFF);
        }
        return buffer;
    }

    public static String encode(String input, int length, char type, boolean encodeAllAbove0xFF) throws UnsupportedEncodingException {
        CharSequence res = XSSEncoder.encode((CharSequence)input, length, type, encodeAllAbove0xFF);
        if (res != null) {
            return ((Object)res).toString();
        }
        return null;
    }

    private static void appendEncoded(Writer wr, CharSequence input, int offset, char type, boolean aboveFF) throws UnsupportedEncodingException, IOException {
        char c = input.charAt(offset);
        if (c < '\u007f') {
            switch (enc_rules[type][c][0]) {
                case '\u0000': {
                    wr.write(c);
                    return;
                }
                case '\u0001': {
                    wr.write(ml_const[enc_rules[type][c][1]]);
                    return;
                }
                case '\u0002': 
                case '\u0003': {
                    switch (type) {
                        case '\u0000': {
                            wr.write(RULE_XX_PREFIX[0]);
                            wr.write(XSSEncoder.getHex(c));
                            wr.write(59);
                            break;
                        }
                        case '\u0001': 
                        case '\u0002': {
                            wr.write(RULE_XX_PREFIX[type]);
                            wr.write(XSSEncoder.getHex(c));
                            break;
                        }
                        case '\u0003': {
                            wr.write(RULE_XX_PREFIX[type]);
                            wr.write(XSSEncoder.getHex(c));
                            if (!XSSEncoder.isNextHex(input, offset)) break;
                            wr.write(32);
                            break;
                        }
                    }
                    return;
                }
            }
        } else {
            switch (type) {
                case '\u0000': {
                    if (c < '\u00a0') {
                        wr.write(ml_const[0]);
                        return;
                    }
                    if (c < '\u0100') {
                        wr.write(RULE_XX_PREFIX[0]);
                        wr.write(XSSEncoder.getHex(c));
                        wr.write(59);
                    } else if (aboveFF || c == '\u2028' || c == '\u2029') {
                        wr.write(RULE_XXXX_PREFIX[0]);
                        wr.write(XSSEncoder.getHex(c));
                        wr.write(59);
                    } else {
                        wr.write(c);
                    }
                    return;
                }
                case '\u0001': {
                    if (c < '\u0100') {
                        wr.write(RULE_XX_PREFIX[1]);
                        wr.write(XSSEncoder.getHex(c));
                    } else if (aboveFF || c == '\u2028' || c == '\u2029') {
                        wr.write(RULE_XXXX_PREFIX[1]);
                        wr.write(XSSEncoder.getHex4B(c));
                    } else {
                        wr.write(c);
                    }
                    return;
                }
                case '\u0002': {
                    char[] url = new char[]{c};
                    wr.write(URLEncoder.encode(new String(url), "UTF-8").toLowerCase(Locale.ENGLISH));
                    return;
                }
                case '\u0003': {
                    if (c < '\u0100') {
                        wr.write(RULE_XX_PREFIX[3]);
                        wr.write(XSSEncoder.getHex(c));
                    } else if (aboveFF || c == '\u2028' || c == '\u2029') {
                        wr.write(RULE_XXXX_PREFIX[3]);
                        wr.write(XSSEncoder.getHex(c));
                    } else {
                        wr.write(c);
                        return;
                    }
                    if (XSSEncoder.isNextHex(input, offset)) {
                        wr.write(32);
                    }
                    return;
                }
            }
        }
    }

    private static void appendEncoded(Writer wr, String input, int offset, char type, boolean aboveFF) throws UnsupportedEncodingException, IOException {
        XSSEncoder.appendEncoded(wr, (CharSequence)input, offset, type, aboveFF);
    }

    public static final void writeEncoded(Writer wr, CharSequence input, int length, char type, boolean encodeAllAbove0xFF) throws UnsupportedEncodingException, IOException {
        if (wr == null) {
            throw new NullPointerException("No writer interface provided");
        }
        if (input == null) {
            return;
        }
        int _length = length < 0 ? input.length() : length;
        for (int i = 0; i < _length; ++i) {
            XSSEncoder.appendEncoded(wr, input, i, type, encodeAllAbove0xFF);
        }
    }

    public static final void writeEncoded(Writer wr, String input, int length, char type, boolean encodeAllAbove0xFF) throws UnsupportedEncodingException, IOException {
        XSSEncoder.writeEncoded(wr, (CharSequence)input, length, type, encodeAllAbove0xFF);
    }

    public static final CharSequence encodeXML(CharSequence input) throws UnsupportedEncodingException {
        return XSSEncoder.encode(input, -1, '\u0000', IXSSEncoder.encodeAllAbove0xFF);
    }

    public static final String encodeXML(String input) throws UnsupportedEncodingException {
        CharSequence res = XSSEncoder.encodeXML((CharSequence)input);
        if (res != null) {
            return ((Object)res).toString();
        }
        return null;
    }

    public static final CharSequence encodeHTML(CharSequence input) throws UnsupportedEncodingException {
        return XSSEncoder.encode(input, -1, '\u0000', IXSSEncoder.encodeAllAbove0xFF);
    }

    public static final String encodeHTML(String input) throws UnsupportedEncodingException {
        CharSequence res = XSSEncoder.encodeHTML((CharSequence)input);
        if (res != null) {
            return ((Object)res).toString();
        }
        return null;
    }

    public static final CharSequence encodeXML(CharSequence input, boolean encodeAllAbove0xFF) throws UnsupportedEncodingException {
        return XSSEncoder.encode(input, -1, '\u0000', encodeAllAbove0xFF);
    }

    public static final String encodeXML(String input, boolean encodeAllAbove0xFF) throws UnsupportedEncodingException {
        CharSequence res = XSSEncoder.encodeXML((CharSequence)input, encodeAllAbove0xFF);
        if (res != null) {
            return ((Object)res).toString();
        }
        return null;
    }

    public static final CharSequence encodeHTML(CharSequence input, boolean encodeAllAbove0xFF) throws UnsupportedEncodingException {
        return XSSEncoder.encode(input, -1, '\u0000', encodeAllAbove0xFF);
    }

    public static final String encodeHTML(String input, boolean encodeAllAbove0xFF) throws UnsupportedEncodingException {
        CharSequence res = XSSEncoder.encodeHTML((CharSequence)input, encodeAllAbove0xFF);
        if (res != null) {
            return ((Object)res).toString();
        }
        return null;
    }

    public static final CharSequence encodeXML(CharSequence input, int maxLength, boolean encodeAllAbove0xFF) throws UnsupportedEncodingException {
        return XSSEncoder.encode(input, maxLength, '\u0000', encodeAllAbove0xFF);
    }

    public static final String encodeXML(String input, int maxLength, boolean encodeAllAbove0xFF) throws UnsupportedEncodingException {
        CharSequence res = XSSEncoder.encodeXML((CharSequence)input, maxLength, encodeAllAbove0xFF);
        if (res != null) {
            return ((Object)res).toString();
        }
        return null;
    }

    public static final CharSequence encodeHTML(CharSequence input, int maxLength, boolean encodeAllAbove0xFF) throws UnsupportedEncodingException {
        return XSSEncoder.encode(input, maxLength, '\u0000', encodeAllAbove0xFF);
    }

    public static final String encodeHTML(String input, int maxLength, boolean encodeAllAbove0xFF) throws UnsupportedEncodingException {
        CharSequence res = XSSEncoder.encodeHTML((CharSequence)input, maxLength, encodeAllAbove0xFF);
        if (res != null) {
            return ((Object)res).toString();
        }
        return null;
    }

    public static final void writeEncodedHTML(Writer wr, CharSequence input) throws UnsupportedEncodingException, IOException {
        XSSEncoder.writeEncoded(wr, input, -1, '\u0000', IXSSEncoder.encodeAllAbove0xFF);
    }

    public static final void writeEncodedHTML(Writer wr, String input) throws UnsupportedEncodingException, IOException {
        XSSEncoder.writeEncodedHTML(wr, (CharSequence)input);
    }

    public static final void writeEncodedXML(Writer wr, CharSequence input) throws UnsupportedEncodingException, IOException {
        XSSEncoder.writeEncoded(wr, input, -1, '\u0000', IXSSEncoder.encodeAllAbove0xFF);
    }

    public static final void writeEncodedXML(Writer wr, String input) throws UnsupportedEncodingException, IOException {
        XSSEncoder.writeEncodedXML(wr, (CharSequence)input);
    }

    public static final void writeEncodedHTML(Writer wr, CharSequence input, boolean encodeAllAbove0xFF) throws UnsupportedEncodingException, IOException {
        XSSEncoder.writeEncoded(wr, input, -1, '\u0000', encodeAllAbove0xFF);
    }

    public static final void writeEncodedHTML(Writer wr, String input, boolean encodeAllAbove0xFF) throws UnsupportedEncodingException, IOException {
        XSSEncoder.writeEncodedHTML(wr, (CharSequence)input, encodeAllAbove0xFF);
    }

    public static final void writeEncodedXML(Writer wr, CharSequence input, boolean encodeAllAbove0xFF) throws UnsupportedEncodingException, IOException {
        XSSEncoder.writeEncoded(wr, input, -1, '\u0000', encodeAllAbove0xFF);
    }

    public static final void writeEncodedXML(Writer wr, String input, boolean encodeAllAbove0xFF) throws UnsupportedEncodingException, IOException {
        XSSEncoder.writeEncodedXML(wr, (CharSequence)input, encodeAllAbove0xFF);
    }

    public static final void writeEncodedHTML(Writer wr, CharSequence input, int maxLength, boolean encodeAllAbove0xFF) throws UnsupportedEncodingException, IOException {
        XSSEncoder.writeEncoded(wr, input, maxLength, '\u0000', encodeAllAbove0xFF);
    }

    public static final void writeEncodedHTML(Writer wr, String input, int maxLength, boolean encodeAllAbove0xFF) throws UnsupportedEncodingException, IOException {
        XSSEncoder.writeEncodedHTML(wr, (CharSequence)input, maxLength, encodeAllAbove0xFF);
    }

    public static final void writeEncodedXML(Writer wr, CharSequence input, int maxLength, boolean encodeAllAbove0xFF) throws UnsupportedEncodingException, IOException {
        XSSEncoder.writeEncoded(wr, input, maxLength, '\u0000', encodeAllAbove0xFF);
    }

    public static final void writeEncodedXML(Writer wr, String input, int maxLength, boolean encodeAllAbove0xFF) throws UnsupportedEncodingException, IOException {
        XSSEncoder.writeEncodedXML(wr, (CharSequence)input, maxLength, encodeAllAbove0xFF);
    }

    public static CharSequence encodeURL(CharSequence input) throws UnsupportedEncodingException {
        return XSSEncoder.encode(input, -1, '\u0002', IXSSEncoder.encodeAllAbove0xFF);
    }

    public static String encodeURL(String input) throws UnsupportedEncodingException {
        CharSequence res = XSSEncoder.encodeURL((CharSequence)input);
        if (res != null) {
            return ((Object)res).toString();
        }
        return null;
    }

    public static CharSequence encodeURL(CharSequence input, boolean encodeAllAbove0xFF) throws UnsupportedEncodingException {
        return XSSEncoder.encode(input, -1, '\u0002', encodeAllAbove0xFF);
    }

    public static String encodeURL(String input, boolean encodeAllAbove0xFF) throws UnsupportedEncodingException {
        CharSequence res = XSSEncoder.encodeURL((CharSequence)input, encodeAllAbove0xFF);
        if (res != null) {
            return ((Object)res).toString();
        }
        return null;
    }

    public static CharSequence encodeURL(CharSequence input, int maxLength, boolean encodeAllAbove0xFF) throws UnsupportedEncodingException {
        return XSSEncoder.encode(input, maxLength, '\u0002', encodeAllAbove0xFF);
    }

    public static String encodeURL(String input, int maxLength, boolean encodeAllAbove0xFF) throws UnsupportedEncodingException {
        CharSequence res = XSSEncoder.encodeURL((CharSequence)input, maxLength, encodeAllAbove0xFF);
        if (res != null) {
            return ((Object)res).toString();
        }
        return null;
    }

    public static final void writeEncodedURL(Writer wr, CharSequence input) throws UnsupportedEncodingException, IOException {
        XSSEncoder.writeEncoded(wr, input, -1, '\u0002', IXSSEncoder.encodeAllAbove0xFF);
    }

    public static final void writeEncodedURL(Writer wr, String input) throws UnsupportedEncodingException, IOException {
        XSSEncoder.writeEncodedURL(wr, (CharSequence)input);
    }

    public static final void writeEncodedURL(Writer wr, CharSequence input, boolean encodeAllAbove0xFF) throws UnsupportedEncodingException, IOException {
        XSSEncoder.writeEncoded(wr, input, -1, '\u0002', encodeAllAbove0xFF);
    }

    public static final void writeEncodedURL(Writer wr, String input, boolean encodeAllAbove0xFF) throws UnsupportedEncodingException, IOException {
        XSSEncoder.writeEncodedURL(wr, (CharSequence)input, encodeAllAbove0xFF);
    }

    public static final void writeEncodedURL(Writer wr, CharSequence input, int maxLength, boolean encodeAllAbove0xFF) throws UnsupportedEncodingException, IOException {
        XSSEncoder.writeEncoded(wr, input, maxLength, '\u0002', encodeAllAbove0xFF);
    }

    public static final void writeEncodedURL(Writer wr, String input, int maxLength, boolean encodeAllAbove0xFF) throws UnsupportedEncodingException, IOException {
        XSSEncoder.writeEncodedURL(wr, (CharSequence)input, maxLength, encodeAllAbove0xFF);
    }

    public static CharSequence encodeJavaScript(CharSequence input) throws UnsupportedEncodingException {
        return XSSEncoder.encode(input, -1, '\u0001', IXSSEncoder.encodeAllAbove0xFF);
    }

    public static String encodeJavaScript(String input) throws UnsupportedEncodingException {
        CharSequence res = XSSEncoder.encodeJavaScript((CharSequence)input);
        if (res != null) {
            return ((Object)res).toString();
        }
        return null;
    }

    public static CharSequence encodeJavaScript(CharSequence input, boolean encodeAllAbove0xFF) throws UnsupportedEncodingException {
        return XSSEncoder.encode(input, -1, '\u0001', encodeAllAbove0xFF);
    }

    public static String encodeJavaScript(String input, boolean encodeAllAbove0xFF) throws UnsupportedEncodingException {
        CharSequence res = XSSEncoder.encodeJavaScript((CharSequence)input, encodeAllAbove0xFF);
        if (res != null) {
            return ((Object)res).toString();
        }
        return null;
    }

    public static CharSequence encodeJavaScript(CharSequence input, int maxLength, boolean encodeAllAbove0xFF) throws UnsupportedEncodingException {
        return XSSEncoder.encode(input, maxLength, '\u0001', encodeAllAbove0xFF);
    }

    public static String encodeJavaScript(String input, int maxLength, boolean encodeAllAbove0xFF) throws UnsupportedEncodingException {
        CharSequence res = XSSEncoder.encodeJavaScript((CharSequence)input, maxLength, encodeAllAbove0xFF);
        if (res != null) {
            return ((Object)res).toString();
        }
        return null;
    }

    public static final void writeEncodedJavaScript(Writer wr, CharSequence input) throws UnsupportedEncodingException, IOException {
        XSSEncoder.writeEncoded(wr, input, -1, '\u0001', IXSSEncoder.encodeAllAbove0xFF);
    }

    public static final void writeEncodedJavaScript(Writer wr, String input) throws UnsupportedEncodingException, IOException {
        XSSEncoder.writeEncodedJavaScript(wr, (CharSequence)input);
    }

    public static final void writeEncodedJavaScript(Writer wr, CharSequence input, boolean encodeAllAbove0xFF) throws UnsupportedEncodingException, IOException {
        XSSEncoder.writeEncoded(wr, input, -1, '\u0001', encodeAllAbove0xFF);
    }

    public static final void writeEncodedJavaScript(Writer wr, String input, boolean encodeAllAbove0xFF) throws UnsupportedEncodingException, IOException {
        XSSEncoder.writeEncodedJavaScript(wr, (CharSequence)input, encodeAllAbove0xFF);
    }

    public static final void writeEncodedJavaScript(Writer wr, CharSequence input, int maxLength, boolean encodeAllAbove0xFF) throws UnsupportedEncodingException, IOException {
        XSSEncoder.writeEncoded(wr, input, maxLength, '\u0001', encodeAllAbove0xFF);
    }

    public static final void writeEncodedJavaScript(Writer wr, String input, int maxLength, boolean encodeAllAbove0xFF) throws UnsupportedEncodingException, IOException {
        XSSEncoder.writeEncodedJavaScript(wr, (CharSequence)input, maxLength, encodeAllAbove0xFF);
    }

    public static CharSequence encodeCSS(CharSequence input) throws UnsupportedEncodingException {
        return XSSEncoder.encode(input, -1, '\u0003', IXSSEncoder.encodeAllAbove0xFF);
    }

    public static String encodeCSS(String input) throws UnsupportedEncodingException {
        CharSequence res = XSSEncoder.encodeCSS((CharSequence)input);
        if (res != null) {
            return ((Object)res).toString();
        }
        return null;
    }

    public static CharSequence encodeCSS(CharSequence input, boolean encodeAllAbove0xFF) throws UnsupportedEncodingException {
        return XSSEncoder.encode(input, -1, '\u0003', encodeAllAbove0xFF);
    }

    public static String encodeCSS(String input, boolean encodeAllAbove0xFF) throws UnsupportedEncodingException {
        CharSequence res = XSSEncoder.encodeCSS((CharSequence)input, encodeAllAbove0xFF);
        if (res != null) {
            return ((Object)res).toString();
        }
        return null;
    }

    public static CharSequence encodeCSS(CharSequence input, int maxLength, boolean encodeAllAbove0xFF) throws UnsupportedEncodingException {
        return XSSEncoder.encode(input, maxLength, '\u0003', encodeAllAbove0xFF);
    }

    public static String encodeCSS(String input, int maxLength, boolean encodeAllAbove0xFF) throws UnsupportedEncodingException {
        CharSequence res = XSSEncoder.encodeCSS((CharSequence)input, maxLength, encodeAllAbove0xFF);
        if (res != null) {
            return ((Object)res).toString();
        }
        return null;
    }

    public static final void writeEncodedCSS(Writer wr, CharSequence input) throws UnsupportedEncodingException, IOException {
        XSSEncoder.writeEncoded(wr, input, -1, '\u0003', IXSSEncoder.encodeAllAbove0xFF);
    }

    public static final void writeEncodedCSS(Writer wr, String input) throws UnsupportedEncodingException, IOException {
        XSSEncoder.writeEncodedCSS(wr, (CharSequence)input);
    }

    public static final void writeEncodedCSS(Writer wr, CharSequence input, boolean encodeAllAbove0xFF) throws UnsupportedEncodingException, IOException {
        XSSEncoder.writeEncoded(wr, input, -1, '\u0003', encodeAllAbove0xFF);
    }

    public static final void writeEncodedCSS(Writer wr, String input, boolean encodeAllAbove0xFF) throws UnsupportedEncodingException, IOException {
        XSSEncoder.writeEncodedCSS(wr, (CharSequence)input, encodeAllAbove0xFF);
    }

    public static final void writeEncodedCSS(Writer wr, CharSequence input, int maxLength, boolean encodeAllAbove0xFF) throws UnsupportedEncodingException, IOException {
        XSSEncoder.writeEncoded(wr, input, maxLength, '\u0003', encodeAllAbove0xFF);
    }

    public static final void writeEncodedCSS(Writer wr, String input, int maxLength, boolean encodeAllAbove0xFF) throws UnsupportedEncodingException, IOException {
        XSSEncoder.writeEncodedCSS(wr, (CharSequence)input, maxLength, encodeAllAbove0xFF);
    }

    public static final IXSSEncoder getInstance() {
        return XSSEncoder.getInstance(IXSSEncoder.encodeAllAbove0xFF);
    }

    public static final IXSSEncoder getInstance(boolean encodeAllAbove0xFF) {
        if (encodeAllAbove0xFF) {
            if (inst_EncodeAllAboveFF == null) {
                inst_EncodeAllAboveFF = new XSSEncoderImpl(true);
            }
            return inst_EncodeAllAboveFF;
        }
        if (inst_EncodeNotAboveFF == null) {
            inst_EncodeNotAboveFF = new XSSEncoderImpl(false);
        }
        return inst_EncodeNotAboveFF;
    }

    private static final class XSSEncoderImpl
    implements IXSSEncoder {
        private boolean encodeFF;

        XSSEncoderImpl(boolean encodeAllAboveFF) {
            this.encodeFF = encodeAllAboveFF;
        }

        public CharSequence encodeURL(CharSequence input) throws UnsupportedEncodingException {
            return XSSEncoder.encode(input, -1, '\u0002', this.encodeFF);
        }

        public String encodeURL(String input) throws UnsupportedEncodingException {
            return XSSEncoder.encode(input, -1, '\u0002', this.encodeFF);
        }

        public CharSequence encodeHTML(CharSequence input) throws UnsupportedEncodingException {
            return XSSEncoder.encode(input, -1, '\u0000', this.encodeFF);
        }

        public String encodeHTML(String input) throws UnsupportedEncodingException {
            return XSSEncoder.encode(input, -1, '\u0000', this.encodeFF);
        }

        public CharSequence encodeXML(CharSequence input) throws UnsupportedEncodingException {
            return XSSEncoder.encode(input, -1, '\u0000', this.encodeFF);
        }

        public String encodeXML(String input) throws UnsupportedEncodingException {
            return XSSEncoder.encode(input, -1, '\u0000', this.encodeFF);
        }

        public CharSequence encodeJavaScript(CharSequence input) throws UnsupportedEncodingException {
            return XSSEncoder.encode(input, -1, '\u0001', this.encodeFF);
        }

        public String encodeJavaScript(String input) throws UnsupportedEncodingException {
            return XSSEncoder.encode(input, -1, '\u0001', this.encodeFF);
        }

        public CharSequence encodeCSS(CharSequence input) throws UnsupportedEncodingException {
            return XSSEncoder.encode(input, -1, '\u0003', this.encodeFF);
        }

        public String encodeCSS(String input) throws UnsupportedEncodingException {
            return XSSEncoder.encode(input, -1, '\u0003', this.encodeFF);
        }

        public void writeEncodedHTML(Writer wr, CharSequence input) throws UnsupportedEncodingException, IOException {
            XSSEncoder.writeEncoded(wr, input, -1, '\u0000', this.encodeFF);
        }

        public void writeEncodedHTML(Writer wr, String input) throws UnsupportedEncodingException, IOException {
            XSSEncoder.writeEncoded(wr, input, -1, '\u0000', this.encodeFF);
        }

        public void writeEncodedXML(Writer wr, CharSequence input) throws UnsupportedEncodingException, IOException {
            XSSEncoder.writeEncoded(wr, input, -1, '\u0000', this.encodeFF);
        }

        public void writeEncodedXML(Writer wr, String input) throws UnsupportedEncodingException, IOException {
            XSSEncoder.writeEncoded(wr, input, -1, '\u0000', this.encodeFF);
        }

        public void writeEncodedURL(Writer wr, CharSequence input) throws UnsupportedEncodingException, IOException {
            XSSEncoder.writeEncoded(wr, input, -1, '\u0002', this.encodeFF);
        }

        public void writeEncodedURL(Writer wr, String input) throws UnsupportedEncodingException, IOException {
            XSSEncoder.writeEncoded(wr, input, -1, '\u0002', this.encodeFF);
        }

        public void writeEncodedJavaScript(Writer wr, CharSequence input) throws UnsupportedEncodingException, IOException {
            XSSEncoder.writeEncoded(wr, input, -1, '\u0001', this.encodeFF);
        }

        public void writeEncodedJavaScript(Writer wr, String input) throws UnsupportedEncodingException, IOException {
            XSSEncoder.writeEncoded(wr, input, -1, '\u0001', this.encodeFF);
        }

        public void writeEncodedCSS(Writer wr, CharSequence input) throws UnsupportedEncodingException, IOException {
            XSSEncoder.writeEncoded(wr, input, -1, '\u0003', this.encodeFF);
        }

        public void writeEncodedCSS(Writer wr, String input) throws UnsupportedEncodingException, IOException {
            XSSEncoder.writeEncoded(wr, input, -1, '\u0003', this.encodeFF);
        }

        public CharSequence encode(CharSequence input, char type) throws UnsupportedEncodingException {
            return XSSEncoder.encode(input, -1, type, this.encodeFF);
        }

        public String encode(String input, char type) throws UnsupportedEncodingException {
            return XSSEncoder.encode(input, -1, type, this.encodeFF);
        }

        public void writeEncoded(Writer wr, CharSequence input, char type) throws UnsupportedEncodingException, IOException {
            XSSEncoder.writeEncoded(wr, input, -1, type, this.encodeFF);
        }

        public void writeEncoded(Writer wr, String input, char type) throws UnsupportedEncodingException, IOException {
            XSSEncoder.writeEncoded(wr, input, -1, type, this.encodeFF);
        }
    }
}

