/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.server.csi.util;

import com.sap.security.core.server.csi.IXSSEncoder;
import com.sap.security.core.server.csi.XSSEncoder;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;

public class StringUtils {
    private static final boolean m_useXSS;
    private static final int UNDEFINED_INPUT_LENGTH = -1;
    private static final String ENTITY_START = "&#";
    private static final String ENTITY_END = ";";
    private static final String LT = "&lt;";
    private static final String GT = "&gt;";
    private static final String AMP = "&amp;";
    private static final String EQU = "&#61;";
    private static final String DQM = "&quot;";
    private static final String SQM = "&#39;";
    private static final String DQM_JS = "\\\"";
    private static final String SQM_JS = "\\'";
    private static final String BKS_JS = "\\\\";
    private static final String SCRIPT = "script:";
    private static final int P_COLON;
    private static final char COLON_REPL = ';';
    private static final String ESC_NEWLINE = "\\n";
    private static final String ESC_LINEFEED = "\\r";
    private static final String ESC_LINESEPERATOR = "\\u2028";
    private static final String ESC_PARASEPARATOR = "\\u2029";
    private static final String ESC_LT = "\\u003c";
    private static final String ESC_GT = "\\u003e";
    private static final char[] TOESCAPE_ST;
    private static final char[] TOESCAPE_HTML;
    private static final char[] TOESCAPE_TAG;
    private static final char[] TOESCAPE_URL;
    private static final char[] TOESCAPE_JS;
    private static final String[] ESCAPEWITH_ST;
    private static final String[] ESCAPEWITH_HTML;
    private static final String[] ESCAPEWITH_TAG;
    private static final String[] ESCAPEWITH_URL;
    private static final String[] ESCAPEWITH_JS;
    private static BitSet toEscape;
    static boolean[] dontNeedEncoding;
    static final String[] hex;

    public static String escapeToJS(String input) {
        if (input == null) {
            return null;
        }
        try {
            if (m_useXSS) {
                String cs = XSSEncoder.encodeJavaScript(input);
                if (cs instanceof String) {
                    return cs;
                }
                return cs.toString();
            }
            return StringUtils.escapeToJS(input, -1);
        }
        catch (UnsupportedEncodingException e) {
            return "";
        }
    }

    public static String escapeToJS(String input, int maxLength) {
        if (input == null) {
            return null;
        }
        try {
            if (m_useXSS) {
                String cs = XSSEncoder.encodeJavaScript(input, maxLength, IXSSEncoder.encodeAllAbove0xFF);
                if (cs instanceof String) {
                    return cs;
                }
                return cs.toString();
            }
            return StringUtils.doEscape(input, maxLength, TOESCAPE_JS, ESCAPEWITH_JS, false);
        }
        catch (UnsupportedEncodingException e) {
            return "";
        }
    }

    public static String escapeToJS(StringBuffer sb, String input, int maxLength) {
        if (input == null) {
            return null;
        }
        try {
            if (m_useXSS) {
                String cs = XSSEncoder.encodeJavaScript(input, maxLength, IXSSEncoder.encodeAllAbove0xFF);
                if (cs instanceof String) {
                    return cs;
                }
                return cs.toString();
            }
            return StringUtils.doEscape(sb, input, maxLength, TOESCAPE_JS, ESCAPEWITH_JS, false);
        }
        catch (UnsupportedEncodingException e) {
            return "";
        }
    }

    public static String escapeToHTML(String input) {
        if (input == null) {
            return null;
        }
        try {
            if (m_useXSS) {
                String cs = XSSEncoder.encodeHTML(input);
                if (cs instanceof String) {
                    return cs;
                }
                return cs.toString();
            }
            return StringUtils.escapeToHTML(input, -1);
        }
        catch (UnsupportedEncodingException e) {
            return "";
        }
    }

    public static String escapeToHTML(String input, int maxLength) {
        if (input == null) {
            return null;
        }
        try {
            if (m_useXSS) {
                String cs = XSSEncoder.encodeHTML(input, maxLength, IXSSEncoder.encodeAllAbove0xFF);
                if (cs instanceof String) {
                    return cs;
                }
                return cs.toString();
            }
            return StringUtils.doEscape(input, maxLength, TOESCAPE_HTML, ESCAPEWITH_HTML, true);
        }
        catch (UnsupportedEncodingException e) {
            return "";
        }
    }

    public static String escapeToHTML(StringBuffer sb, String input, int maxLength) {
        if (input == null) {
            return null;
        }
        try {
            if (m_useXSS) {
                String cs = XSSEncoder.encodeHTML(input, maxLength, IXSSEncoder.encodeAllAbove0xFF);
                if (cs instanceof String) {
                    return cs;
                }
                return cs.toString();
            }
            return StringUtils.doEscape(sb, input, maxLength, TOESCAPE_HTML, ESCAPEWITH_HTML, true);
        }
        catch (UnsupportedEncodingException e) {
            return "";
        }
    }

    public static String escapeToAttributeValue(String input) {
        if (input == null) {
            return null;
        }
        try {
            if (m_useXSS) {
                String cs = XSSEncoder.encodeHTML(input);
                if (cs instanceof String) {
                    return cs;
                }
                return cs.toString();
            }
            return StringUtils.escapeToAttributeValue(input, -1);
        }
        catch (UnsupportedEncodingException e) {
            return "";
        }
    }

    public static String escapeToAttributeValue(String input, int maxLength) {
        if (input == null) {
            return null;
        }
        try {
            if (m_useXSS) {
                String cs = XSSEncoder.encodeHTML(input, maxLength, IXSSEncoder.encodeAllAbove0xFF);
                if (cs instanceof String) {
                    return cs;
                }
                return cs.toString();
            }
            return StringUtils.doEscape(input, maxLength, TOESCAPE_TAG, ESCAPEWITH_TAG, true);
        }
        catch (UnsupportedEncodingException e) {
            return "";
        }
    }

    public static String escapeToAttributeValue(StringBuffer sb, String input, int maxLength) {
        if (input == null) {
            return null;
        }
        try {
            if (m_useXSS) {
                String cs = XSSEncoder.encodeHTML(input, maxLength, IXSSEncoder.encodeAllAbove0xFF);
                if (cs instanceof String) {
                    return cs;
                }
                return cs.toString();
            }
            return StringUtils.doEscape(sb, input, maxLength, TOESCAPE_TAG, ESCAPEWITH_TAG, true);
        }
        catch (UnsupportedEncodingException e) {
            return "";
        }
    }

    public static String escapeToURL(String input) {
        if (input == null) {
            return null;
        }
        try {
            if (m_useXSS) {
                String cs = XSSEncoder.encodeHTML(input);
                if (cs instanceof String) {
                    return cs;
                }
                return cs.toString();
            }
            return StringUtils.escapeToURL(input, -1);
        }
        catch (UnsupportedEncodingException e) {
            return "";
        }
    }

    public static String escapeToURL(String input, int maxLength) {
        if (input == null) {
            return null;
        }
        try {
            if (m_useXSS) {
                String cs = XSSEncoder.encodeHTML(input, maxLength, IXSSEncoder.encodeAllAbove0xFF);
                if (cs instanceof String) {
                    return cs;
                }
                return cs.toString();
            }
            String cInput = StringUtils.lengthAdjust(input, maxLength);
            cInput = StringUtils.disableScriptSignatures(cInput);
            return StringUtils.doEscape(cInput, maxLength, TOESCAPE_URL, ESCAPEWITH_URL, false);
        }
        catch (UnsupportedEncodingException e) {
            return "";
        }
    }

    public static String escapeToURL(StringBuffer sb, String input, int maxLength) {
        if (input == null) {
            return null;
        }
        try {
            if (m_useXSS) {
                String cs = XSSEncoder.encodeHTML(input, maxLength, IXSSEncoder.encodeAllAbove0xFF);
                if (cs instanceof String) {
                    return cs;
                }
                return cs.toString();
            }
            String cInput = StringUtils.lengthAdjust(input, maxLength);
            cInput = StringUtils.disableScriptSignatures(cInput);
            return StringUtils.doEscape(sb, cInput, maxLength, TOESCAPE_URL, ESCAPEWITH_URL, false);
        }
        catch (UnsupportedEncodingException e) {
            return "";
        }
    }

    public static String escapeScriptEndTag(String pStr) {
        if (pStr == null) {
            return null;
        }
        try {
            if (m_useXSS) {
                String cs = XSSEncoder.encodeHTML(pStr);
                if (cs instanceof String) {
                    return cs;
                }
                return cs.toString();
            }
            return StringUtils.doEscape(pStr, -1, TOESCAPE_ST, ESCAPEWITH_ST, false);
        }
        catch (UnsupportedEncodingException e) {
            return "";
        }
    }

    public static String escapeScriptEndTag(StringBuffer sb, String pStr) {
        if (pStr == null) {
            return null;
        }
        try {
            if (m_useXSS) {
                String cs = XSSEncoder.encodeHTML(pStr);
                if (cs instanceof String) {
                    return cs;
                }
                return cs.toString();
            }
            return StringUtils.doEscape(sb, pStr, -1, TOESCAPE_ST, ESCAPEWITH_ST, false);
        }
        catch (UnsupportedEncodingException e) {
            return "";
        }
    }

    public static String escapeSpace(String input) {
        if (input == null) {
            return null;
        }
        char[] array = input.toCharArray();
        for (int i = 0; i < input.length(); ++i) {
            if (' ' != array[i]) continue;
            array[i] = 43;
        }
        return String.valueOf(array);
    }

    private static String lengthAdjust(String input, int maxLength) {
        if (input != null && maxLength > -1 && maxLength < input.length()) {
            return input.substring(0, maxLength);
        }
        return input;
    }

    private static String decodeEntities(String input) {
        StringBuffer buffy = new StringBuffer(input.length());
        String cInput = input.toLowerCase(Locale.ENGLISH);
        int a = 0;
        int i = 0;
        while (i >= 0) {
            int e = -1;
            i = cInput.indexOf(ENTITY_START, a);
            if (i < 0) continue;
            int j = cInput.indexOf(ENTITY_END, i);
            if (j >= 0) {
                int iBase;
                String cSub = cInput.substring(i + 2, j);
                if (cSub.charAt(0) == 'x') {
                    cSub = cSub.substring(1);
                    iBase = 16;
                } else {
                    iBase = 10;
                }
                try {
                    e = Integer.parseInt(cSub, iBase);
                }
                catch (NumberFormatException nfe) {
                    e = -1;
                }
            }
            if (e > 0 && e < 65536) {
                buffy.append(input.substring(a, i)).append((char)e);
                a = j + 1;
                continue;
            }
            a = i + 1;
        }
        buffy.append(input.substring(a));
        return buffy.toString();
    }

    private static String removeWhitespace(String input) {
        StringBuffer buffy = new StringBuffer(input.length());
        if (input != null) {
            for (int i = 0; i < input.length(); ++i) {
                char chr = input.charAt(i);
                if (chr != ' ' && (chr <= ' ' || Character.isWhitespace(chr))) continue;
                buffy.append(input.charAt(i));
            }
        }
        return buffy.toString();
    }

    private static String disableScriptSignatures(String input) {
        String decodedInput = StringUtils.decodeEntities(input);
        String canonicalInput = StringUtils.removeWhitespace(decodedInput);
        StringBuffer safeData = new StringBuffer(canonicalInput);
        String tempData = canonicalInput.toLowerCase(Locale.ENGLISH);
        int i = 0;
        while (i >= 0) {
            if ((i = tempData.indexOf(SCRIPT, i)) < 0) continue;
            safeData.setCharAt(i += P_COLON, ';');
            ++i;
        }
        return safeData.toString();
    }

    private static String doEscape(String input, int maxLength, char[] toEscape, String[] escapeWith, boolean handleEntities) {
        StringBuffer buffy = new StringBuffer(input.length() << 1);
        return StringUtils.doEscape(buffy, input, maxLength, toEscape, escapeWith, handleEntities);
    }

    private static String doEscape(StringBuffer buffy, String input, int maxLength, char[] toEscape, String[] escapeWith, boolean handleEntities) {
        if (input != null && toEscape != null && escapeWith != null) {
            String sIn = StringUtils.lengthAdjust(input, maxLength);
            int l = sIn.length();
            for (int i = 0; i < l; ++i) {
                int j;
                char chr = sIn.charAt(i);
                if (handleEntities && chr >= '\u007f') {
                    buffy.append(StringUtils.encodeToEntity(chr));
                    continue;
                }
                for (j = 0; j < toEscape.length; ++j) {
                    if (chr != toEscape[j]) continue;
                    buffy.append(escapeWith[j]);
                    break;
                }
                if (j < toEscape.length) continue;
                buffy.append(chr);
            }
            return buffy.toString();
        }
        return null;
    }

    private static String encodeToEntity(char chr) {
        StringBuffer result = new StringBuffer(7);
        result.append(ENTITY_START);
        result.append((int)chr);
        result.append(ENTITY_END);
        return result.toString();
    }

    private static String encodeUTF8(String s, char[] forceEncode) {
        StringBuffer sb = new StringBuffer(s.length() * 2);
        return StringUtils.encodeUTF8(sb, s, forceEncode);
    }

    private static String encodeUTF8(StringBuffer sbuf, String s, char[] forceEncode) {
        int i;
        int len = s.length();
        boolean[] toBeEncoded = null;
        if (forceEncode != null && forceEncode.length > 0) {
            toBeEncoded = new boolean[256];
            for (i = 0; i < forceEncode.length; ++i) {
                toBeEncoded[forceEncode[i]] = true;
            }
        }
        for (i = 0; i < len; ++i) {
            char ch = s.charAt(i);
            if (toBeEncoded != null && toBeEncoded[ch]) {
                sbuf.append(hex[ch]);
                continue;
            }
            if ('A' <= ch && ch <= 'Z') {
                sbuf.append(ch);
                continue;
            }
            if ('a' <= ch && ch <= 'z') {
                sbuf.append(ch);
                continue;
            }
            if ('0' <= ch && ch <= '9') {
                sbuf.append(ch);
                continue;
            }
            if (ch == ' ') {
                sbuf.append('+');
                continue;
            }
            if (ch == '-' || ch == '_' || ch == '.' || ch == '!' || ch == '~' || ch == '*' || ch == '\'' || ch == '(' || ch == ')') {
                sbuf.append(ch);
                continue;
            }
            if (ch <= '\u007f') {
                sbuf.append(hex[ch]);
                continue;
            }
            if (ch <= '\u07ff') {
                sbuf.append(hex[0xC0 | ch >> 6]);
                sbuf.append(hex[0x80 | ch & 0x3F]);
                continue;
            }
            sbuf.append(hex[0xE0 | ch >> 12]);
            sbuf.append(hex[0x80 | ch >> 6 & 0x3F]);
            sbuf.append(hex[0x80 | ch & 0x3F]);
        }
        return sbuf.toString();
    }

    private static String decodeUTF8(String s) throws UnsupportedEncodingException {
        StringBuffer sb = new StringBuffer();
        return StringUtils.decodeUTF8(sb, s);
    }

    private static String decodeUTF8(StringBuffer sb, String s) throws UnsupportedEncodingException {
        boolean needToChange = false;
        String enc = "utf-8";
        int numChars = s.length();
        int i = 0;
        block6: while (i < numChars) {
            char c = s.charAt(i);
            switch (c) {
                case '+': {
                    sb.append(' ');
                    ++i;
                    needToChange = true;
                    continue block6;
                }
                case '%': {
                    try {
                        byte[] bytes = new byte[(numChars - i) / 3];
                        int pos = 0;
                        while (i + 2 < numChars && c == '%') {
                            bytes[pos++] = (byte)Integer.parseInt(s.substring(i + 1, i + 3), 16);
                            if ((i += 3) >= numChars) continue;
                            c = s.charAt(i);
                        }
                        if (i < numChars && c == '%') {
                            throw new IllegalArgumentException("decoder: Incomplete trailing escape (%) pattern");
                        }
                        sb.append(new String(bytes, 0, pos, "utf-8"));
                    }
                    catch (NumberFormatException e) {
                        throw new IllegalArgumentException("decoder: Illegal hex characters in escape (%) pattern - " + e.getMessage());
                    }
                    needToChange = true;
                    continue block6;
                }
            }
            sb.append(c);
            ++i;
        }
        return needToChange ? sb.toString() : s;
    }

    public static String urlEncode(StringBuffer sb, String s, char[] forceEncode) {
        if (s == null) {
            return null;
        }
        try {
            if (m_useXSS) {
                String cs = XSSEncoder.encodeURL(s, IXSSEncoder.encodeAllAbove0xFF);
                if (cs instanceof String) {
                    return cs;
                }
                return cs.toString();
            }
            return StringUtils.encodeUTF8(sb, s, forceEncode);
        }
        catch (UnsupportedEncodingException e) {
            return "";
        }
    }

    public static String urlEncode(String s, char[] forceEncode) {
        if (s == null) {
            return null;
        }
        try {
            if (m_useXSS) {
                String cs = XSSEncoder.encodeURL(s, IXSSEncoder.encodeAllAbove0xFF);
                if (cs instanceof String) {
                    return cs;
                }
                return cs.toString();
            }
            return StringUtils.encodeUTF8(s, forceEncode);
        }
        catch (UnsupportedEncodingException e) {
            return "";
        }
    }

    public static String urlEncode(String s) {
        return StringUtils.urlEncode(s, null);
    }

    public static String urlDecode(StringBuffer sb, String s) {
        try {
            return StringUtils.decodeUTF8(sb, s);
        }
        catch (UnsupportedEncodingException ue) {
            return null;
        }
    }

    public static String urlDecode(String s) {
        try {
            return StringUtils.decodeUTF8(s);
        }
        catch (UnsupportedEncodingException ue) {
            return null;
        }
    }

    public static String[] tokenize(String szInput, String szDelim) {
        List l = StringUtils.tokenizeInList(szInput, szDelim);
        String[] array = new String[l.size()];
        String[] res = l.toArray(array);
        return res;
    }

    public static List tokenizeInList(String szInput, String szDelim) {
        ArrayList<String> l = new ArrayList<String>();
        StringTokenizer t = new StringTokenizer(szInput, szDelim);
        while (t.hasMoreTokens()) {
            l.add(t.nextToken());
        }
        return l;
    }

    public static String[] tokenize(String szInput, char delimiter) {
        List l = StringUtils.tokenizeInList(szInput, delimiter);
        String[] array = new String[l.size()];
        String[] res = l.toArray(array);
        return res;
    }

    public static List tokenizeInList(String szInput, char delimiter) {
        ArrayList<String> l;
        block6: {
            l = new ArrayList<String>();
            int begin = 0;
            int end = szInput.indexOf(delimiter, 0);
            int length = szInput.length();
            if (length == 0) {
                return l;
            }
            do {
                if (begin != end) {
                    if (end == -1 && begin == 0) {
                        l.add(szInput.substring(begin));
                    } else {
                        l.add(szInput.substring(begin, end));
                    }
                }
                if (end == -1) break block6;
            } while ((end = szInput.indexOf(delimiter, begin = end + 1)) != -1);
            if (begin != length) {
                l.add(szInput.substring(begin));
            }
        }
        return l;
    }

    private static int join(char[] path, int[] segs) {
        int ns = segs.length;
        int end = path.length - 1;
        int p = 0;
        if (path[p] == '\u0000') {
            path[p++] = 47;
        }
        for (int i = 0; i < ns; ++i) {
            int q = segs[i];
            if (q == -1) continue;
            if (p == q) {
                while (p <= end && path[p] != '\u0000') {
                    ++p;
                }
                if (p > end) continue;
                path[p++] = 47;
                continue;
            }
            if (p < q) {
                while (q <= end && path[q] != '\u0000') {
                    path[p++] = path[q++];
                }
                if (q > end) continue;
                path[p++] = 47;
                continue;
            }
            throw new InternalError();
        }
        return p;
    }

    private static void maybeAddLeadingDot(char[] path, int[] segs) {
        int p;
        int f;
        if (path[0] == '\u0000') {
            return;
        }
        int ns = segs.length;
        for (f = 0; f < ns && segs[f] < 0; ++f) {
        }
        if (f >= ns || f == 0) {
            return;
        }
        for (p = segs[f]; p < path.length && path[p] != ':' && path[p] != '\u0000'; ++p) {
        }
        if (p >= path.length || path[p] == '\u0000') {
            return;
        }
        path[0] = 46;
        path[1] = '\u0000';
        segs[0] = 0;
    }

    private static void split(char[] path, int[] segs) {
        int p;
        int end = path.length - 1;
        int i = 0;
        for (p = 0; p <= end && path[p] == '/'; ++p) {
            path[p] = '\u0000';
        }
        block1: while (p <= end) {
            segs[i++] = p++;
            while (p <= end) {
                if (path[p++] != '/') continue;
                path[p - 1] = '\u0000';
                while (p <= end && path[p] == '/') {
                    path[p++] = '\u0000';
                }
                continue block1;
            }
        }
        if (i != segs.length) {
            throw new InternalError();
        }
    }

    private static void removeDots(char[] path, int[] segs) {
        int ns = segs.length;
        int end = path.length - 1;
        for (int i = 0; i < ns; ++i) {
            int q;
            int j;
            int dots = 0;
            do {
                int p;
                if (path[p = segs[i]] != '.') continue;
                if (p == end) {
                    dots = 1;
                    break;
                }
                if (path[p + 1] == '\u0000') {
                    dots = 1;
                    break;
                }
                if (path[p + 1] != '.' || p + 1 != end && path[p + 2] != '\u0000') continue;
                dots = 2;
                break;
            } while (++i < ns);
            if (i > ns || dots == 0) break;
            if (dots == 1) {
                segs[i] = -1;
                continue;
            }
            for (j = i - 1; j >= 0 && segs[j] == -1; --j) {
            }
            if (j < 0 || path[q = segs[j]] == '.' && path[q + 1] == '.' && path[q + 2] == '\u0000') continue;
            segs[i] = -1;
            segs[j] = -1;
        }
    }

    private static int needsNormalization(char[] path) {
        int p;
        boolean normal = true;
        int ns = 0;
        int end = path.length - 1;
        for (p = 0; p <= end && path[p] == '/'; ++p) {
        }
        if (p > 1) {
            normal = false;
        }
        block1: while (p <= end) {
            if (path[p] == '.' && (p == end || path[p + 1] == '/' || path[p + 1] == '.' && (p + 1 == end || path[p + 2] == '/'))) {
                normal = false;
            }
            ++ns;
            while (p <= end) {
                if (path[p++] != '/') continue;
                while (p <= end && path[p] == '/') {
                    normal = false;
                    ++p;
                }
                continue block1;
            }
        }
        return normal ? -1 : ns;
    }

    public static String urlNormalize(String ps) {
        if (ps == null) {
            return null;
        }
        char[] path = ps.toCharArray();
        int ns = StringUtils.needsNormalization(path);
        if (ns < 0) {
            return ps;
        }
        int[] segs = new int[ns];
        StringUtils.split(path, segs);
        StringUtils.removeDots(path, segs);
        StringUtils.maybeAddLeadingDot(path, segs);
        String s = new String(path, 0, StringUtils.join(path, segs));
        if (s.equals(ps)) {
            return ps;
        }
        return s;
    }

    public static String urlNormalize2(String ps) {
        char[] name = new char[ps.length() + 1];
        ps.getChars(0, ps.length(), name, 0);
        name[ps.length()] = '\u0000';
        int l = 0;
        int w = 0;
        while (name[l] != '\u0000') {
            if (name[l] == '.' && name[l + 1] == '/' && (l == 0 || name[l - 1] == '/')) {
                l += 2;
                continue;
            }
            name[w++] = name[l++];
        }
        if (w == 1 && name[0] == '.') {
            --w;
        } else if (w > 1 && name[w - 1] == '.' && name[w - 2] == '/') {
            --w;
        }
        name[w] = '\u0000';
        l = 0;
        while (name[l] != '\u0000') {
            if (name[l] == '.' && name[l + 1] == '.' && name[l + 2] == '/' && (l == 0 || name[l - 1] == '/')) {
                int m = l + 3;
                if ((l -= 2) >= 0) {
                    while (l >= 0 && name[l] != '/') {
                        --l;
                    }
                } else {
                    l = 0;
                }
                int n = ++l;
                while ((name[n] = name[m]) != '\u0000') {
                    ++n;
                    ++m;
                }
                continue;
            }
            ++l;
        }
        if (l == 2 && name[0] == '.' && name[1] == '.') {
            name[0] = '\u0000';
            l = 0;
        } else if (l > 2 && name[l - 1] == '.' && name[l - 2] == '.' && name[l - 3] == '/') {
            if ((l -= 4) >= 0) {
                while (l >= 0 && name[l] != '/') {
                    --l;
                }
                ++l;
            } else {
                l = 0;
            }
            name[l] = '\u0000';
        }
        return new String(name, 0, l);
    }

    public static String pathNormalize(String ps) {
        char[] name = new char[ps.length() + 1];
        ps.getChars(0, ps.length(), name, 0);
        name[ps.length()] = '\u0000';
        int l = 0;
        int w = 0;
        while (name[l] != '\u0000') {
            if (!(name[l] != '.' || name[l + 1] != '/' && name[l + 1] != '\\' || l != 0 && name[l - 1] != '/' && name[l - 1] != '\\')) {
                l += 2;
                continue;
            }
            name[w++] = name[l++];
        }
        if (w == 1 && name[0] == '.') {
            --w;
        } else if (w > 1 && name[w - 1] == '.' && (name[w - 2] == '/' || name[w - 2] == '\\')) {
            --w;
        }
        name[w] = '\u0000';
        l = 0;
        while (name[l] != '\u0000') {
            if (!(name[l] != '.' || name[l + 1] != '.' || name[l + 2] != '/' && name[l + 2] != '\\' || l != 0 && name[l - 1] != '/' && name[l - 1] != '\\')) {
                int m = l + 3;
                if ((l -= 2) >= 0) {
                    while (l >= 0 && name[l] != '/' && name[l] != '\\') {
                        --l;
                    }
                } else {
                    l = 0;
                }
                int n = ++l;
                while ((name[n] = name[m]) != '\u0000') {
                    ++n;
                    ++m;
                }
                continue;
            }
            ++l;
        }
        if (l == 2 && name[0] == '.' && name[1] == '.') {
            name[0] = '\u0000';
            l = 0;
        } else if (l > 2 && name[l - 1] == '.' && name[l - 2] == '.' && (name[l - 3] == '/' || name[l - 3] == '\\')) {
            if ((l -= 4) >= 0) {
                while (l >= 0 && name[l] != '/' && name[l] != '\\') {
                    --l;
                }
                ++l;
            } else {
                l = 0;
            }
            name[l] = '\u0000';
        }
        return new String(name, 0, l);
    }

    static {
        int i;
        m_useXSS = System.getProperty("com.sap.security.xssencode", "0").compareTo("1") == 0;
        P_COLON = SCRIPT.indexOf(58);
        TOESCAPE_ST = new char[]{'<', '>'};
        TOESCAPE_HTML = new char[]{'<', '>', '&', '\'', '\"'};
        TOESCAPE_TAG = new char[]{'<', '>', '&', '\'', '\"', '='};
        TOESCAPE_URL = new char[]{'<', '>', '\'', '\"'};
        TOESCAPE_JS = new char[]{'<', '>', '\'', '\"', '\\', '\n', '\r', '\u2028', '\u2029'};
        ESCAPEWITH_ST = new String[]{ESC_LT, ESC_GT};
        ESCAPEWITH_HTML = new String[]{LT, GT, AMP, SQM, DQM};
        ESCAPEWITH_TAG = new String[]{LT, GT, AMP, SQM, DQM, EQU};
        ESCAPEWITH_URL = new String[]{LT, GT, SQM, DQM};
        ESCAPEWITH_JS = new String[]{ESC_LT, ESC_GT, SQM_JS, DQM_JS, BKS_JS, ESC_NEWLINE, ESC_LINEFEED, ESC_LINESEPERATOR, ESC_PARASEPARATOR};
        toEscape = new BitSet();
        dontNeedEncoding = new boolean[256];
        for (i = 97; i <= 122; ++i) {
            StringUtils.dontNeedEncoding[i] = true;
        }
        for (i = 65; i <= 90; ++i) {
            StringUtils.dontNeedEncoding[i] = true;
        }
        for (i = 48; i <= 57; ++i) {
            StringUtils.dontNeedEncoding[i] = true;
        }
        StringUtils.dontNeedEncoding[32] = true;
        StringUtils.dontNeedEncoding[45] = true;
        StringUtils.dontNeedEncoding[95] = true;
        StringUtils.dontNeedEncoding[46] = true;
        StringUtils.dontNeedEncoding[42] = true;
        char[] toBeEscaped = new char[]{'\'', '\"', '&', '<', '>', '+', '\u00a9', '\u00ae', '\u00b6', '\u00bc', '\u00bd', '\u00be'};
        for (i = 0; i < toBeEscaped.length; ++i) {
            toEscape.set(toBeEscaped[i]);
        }
        hex = new String[]{"%00", "%01", "%02", "%03", "%04", "%05", "%06", "%07", "%08", "%09", "%0a", "%0b", "%0c", "%0d", "%0e", "%0f", "%10", "%11", "%12", "%13", "%14", "%15", "%16", "%17", "%18", "%19", "%1a", "%1b", "%1c", "%1d", "%1e", "%1f", "%20", "%21", "%22", "%23", "%24", "%25", "%26", "%27", "%28", "%29", "%2a", "%2b", "%2c", "%2d", "%2e", "%2f", "%30", "%31", "%32", "%33", "%34", "%35", "%36", "%37", "%38", "%39", "%3a", "%3b", "%3c", "%3d", "%3e", "%3f", "%40", "%41", "%42", "%43", "%44", "%45", "%46", "%47", "%48", "%49", "%4a", "%4b", "%4c", "%4d", "%4e", "%4f", "%50", "%51", "%52", "%53", "%54", "%55", "%56", "%57", "%58", "%59", "%5a", "%5b", "%5c", "%5d", "%5e", "%5f", "%60", "%61", "%62", "%63", "%64", "%65", "%66", "%67", "%68", "%69", "%6a", "%6b", "%6c", "%6d", "%6e", "%6f", "%70", "%71", "%72", "%73", "%74", "%75", "%76", "%77", "%78", "%79", "%7a", "%7b", "%7c", "%7d", "%7e", "%7f", "%80", "%81", "%82", "%83", "%84", "%85", "%86", "%87", "%88", "%89", "%8a", "%8b", "%8c", "%8d", "%8e", "%8f", "%90", "%91", "%92", "%93", "%94", "%95", "%96", "%97", "%98", "%99", "%9a", "%9b", "%9c", "%9d", "%9e", "%9f", "%a0", "%a1", "%a2", "%a3", "%a4", "%a5", "%a6", "%a7", "%a8", "%a9", "%aa", "%ab", "%ac", "%ad", "%ae", "%af", "%b0", "%b1", "%b2", "%b3", "%b4", "%b5", "%b6", "%b7", "%b8", "%b9", "%ba", "%bb", "%bc", "%bd", "%be", "%bf", "%c0", "%c1", "%c2", "%c3", "%c4", "%c5", "%c6", "%c7", "%c8", "%c9", "%ca", "%cb", "%cc", "%cd", "%ce", "%cf", "%d0", "%d1", "%d2", "%d3", "%d4", "%d5", "%d6", "%d7", "%d8", "%d9", "%da", "%db", "%dc", "%dd", "%de", "%df", "%e0", "%e1", "%e2", "%e3", "%e4", "%e5", "%e6", "%e7", "%e8", "%e9", "%ea", "%eb", "%ec", "%ed", "%ee", "%ef", "%f0", "%f1", "%f2", "%f3", "%f4", "%f5", "%f6", "%f7", "%f8", "%f9", "%fa", "%fb", "%fc", "%fd", "%fe", "%ff"};
    }
}

