/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.crypto.keystore.cmd;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.sap.cloud.crypto.keystore.cmd.KeyStoreCommand;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpDelete;

@Parameters(commandDescription="Delete keystore")
public class DeleteKeyStore
extends KeyStoreCommand {
    @Parameter(names={"-n", "--name"}, description="Name of the keystore which has to be deleted")
    protected String keyStoreName;
    @Parameter(names={"-quiet", "--quiet"}, description="Delete without confirmation", hidden=true)
    protected boolean deleteQuitely;

    @Override
    public void run() throws CommandException {
        this.checkMandatoryParameter(this.keyStoreName, "--name");
        if (!this.deleteQuitely) {
            String shouldOverwrite;
            BufferedReader reader = new BufferedReader(new InputStreamReader(System.in, Charset.forName("UTF-8")));
            System.out.print(String.format("Are you sure you want to delete keystore %s (y/n)?", this.keyStoreName));
            try {
                shouldOverwrite = reader.readLine();
            }
            catch (IOException e) {
                throw new CommandException(e);
            }
            if (!"y".equalsIgnoreCase(shouldOverwrite)) {
                return;
            }
        }
        this.askForPassword();
        if (this.allSubscriptions) {
            this.errorMappings.put("Configuration not found!".toLowerCase(), "There is no keystore with name " + this.keyStoreName + " on account " + this.account + " and application " + this.application);
        } else {
            this.errorMappings.put("Configuration not found!".toLowerCase(), "There is no keystore with name " + this.keyStoreName + " on account " + this.account + (this.tenant != null ? " and tenant " + this.tenant : ""));
        }
        String path = this.formKeystoreServicePath(this.keyStoreName);
        String fetchTokenUrl = this.getCsrfTokenUrl();
        HttpDelete request = new HttpDelete(path);
        try {
            HttpClient client = DeleteKeyStore.createHttpClient(request.getURI().toString(), this.user, this.password, fetchTokenUrl);
            HttpResponse response = client.execute(request);
            this.processResponse(response, null);
        }
        catch (IOException e) {
            throw new CommandException(e);
        }
        finally {
            this.cleanup();
        }
    }

    @Override
    public String getName() {
        return "delete-keystore";
    }
}

