/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.crypto.keystore.cmd;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameters;
import com.sap.cloud.crypto.keystore.cmd.KeyStoreCommand;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.util.EntityUtils;

@Parameters(commandDescription="Download keystore to a local file")
public class DownloadKeyStore
extends KeyStoreCommand {
    private static final String QUOTE = "\"";
    private static final String HEADER_PREFIX = "attachment; filename=";
    private static final String CONTENT_DISPOSITION_HEADER = "Content-Disposition";
    @Parameter(names={"-n", "--name"}, description="Name of the keystore which has to be downloaded")
    protected String keyStoreName;
    @Parameter(names={"-l", "--location"}, description="Local directory where the keystore is saved. If it is not specified, the current directory is used.")
    protected String localpath;
    @Parameter(names={"-w", "--overwrite"}, description="Overwrite the keystore if already exists")
    protected boolean overwrite;

    @Override
    public void run() throws CommandException {
        this.checkMandatoryParameter(this.keyStoreName, "--name");
        if (this.localpath == null) {
            this.localpath = ".";
        }
        File localDir = new File(this.localpath);
        localDir.mkdirs();
        if (!localDir.exists() || !localDir.isDirectory()) {
            throw new ParameterException("Invalid value in parameter -l. '" + this.localpath + "' is not a correct path or the directory can not be created");
        }
        this.askForPassword();
        String path = this.formKeystoreServicePath(this.keyStoreName);
        String relativePath = this.allSubscriptions ? path.substring(path.indexOf("/v2"), path.indexOf('/' + this.keyStoreName)) : path.substring(path.indexOf("/SPACES"), path.indexOf('/' + this.keyStoreName));
        if (this.allSubscriptions) {
            this.errorMappings.put("Configuration not found!".toLowerCase(), "There is no keystore with name " + this.keyStoreName + " on account " + this.account + " and application " + this.application);
        } else {
            this.errorMappings.put(("Configuration with name " + this.keyStoreName + " does not exist under path " + relativePath).toLowerCase(), "There is no keystore with name " + this.keyStoreName + " on account " + this.account + (this.tenant != null ? " and tenant " + this.tenant : ""));
        }
        HttpGet request = new HttpGet(path);
        InputStream contentInput = null;
        try {
            HttpClient client = DownloadKeyStore.createHttpClient(request.getURI().toString(), this.user, this.password);
            HttpResponse response = client.execute(request);
            if (response.getStatusLine().getStatusCode() == 200) {
                Header contentHeader = response.getFirstHeader(CONTENT_DISPOSITION_HEADER);
                if (contentHeader == null) {
                    throw new CommandException("Content header Content-Disposition was not returned by the REST API");
                }
                String headerValue = contentHeader.getValue();
                if (headerValue == null || headerValue.indexOf(HEADER_PREFIX) < 0) {
                    throw new CommandException("Content header Content-Disposition was returned by the REST API has unexpected value: " + headerValue);
                }
                int index1 = headerValue.indexOf(QUOTE, HEADER_PREFIX.length()) + 1;
                int index2 = headerValue.indexOf(QUOTE, index1);
                if (index1 < 1 || index2 < 1 || index2 - index1 < 1) {
                    throw new CommandException("Content header Content-Disposition was returned by the REST API has unexpected value: " + headerValue);
                }
                String fileName = headerValue.substring(index1, index2);
                this.checkPathTraversal(headerValue, fileName);
                File keyStoreFile = new File(localDir, fileName);
                if (keyStoreFile.exists() && !this.overwrite) {
                    System.out.println("Warning: Keystore " + keyStoreFile.getCanonicalPath() + " already exists. To replace it, run the command with parameter -w (--overwrite).");
                    return;
                }
                this.saveStreamToFile(response.getEntity().getContent(), keyStoreFile);
                EntityUtils.consume(response.getEntity());
                this.printSuccess(this.getName());
            } else {
                this.processResponse(response, null);
            }
        }
        catch (IOException e) {
            throw new CommandException(e);
        }
        finally {
            try {
                if (contentInput != null) {
                    contentInput.close();
                }
            }
            catch (IOException e) {
                System.out.println("Can't close content input or output stream");
            }
            this.cleanup();
        }
    }

    private void checkPathTraversal(String headerValue, String fileName) {
        if (fileName.contains("/") || fileName.contains("\\") || fileName.contains("..")) {
            throw new CommandException("Path traversal attack detected in header Content-Disposition. Header value is: " + headerValue);
        }
    }

    @Override
    public String getName() {
        return "download-keystore";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveStreamToFile(InputStream is, File file) throws IOException {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(file);
            int read = 0;
            byte[] bytes = new byte[4096];
            while ((read = is.read(bytes)) != -1) {
                fos.write(bytes, 0, read);
            }
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (Exception e) {
                System.out.println("Can't close file output stream: " + e.getMessage());
            }
        }
    }
}

