/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.crypto.keystore.cmd;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.sap.cloud.crypto.keystore.cmd.Constants;
import com.sap.core.utils.security.logon.BasicAuthHttpClientProvider;
import com.sap.core.utils.security.logon.LogonUtils;
import com.sap.jpaas.infrastructure.console.command.RemoteCommand;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import com.sap.jpaas.infrastructure.console.validator.SACValidator;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.util.EntityUtils;

public abstract class KeyStoreCommand
extends RemoteCommand {
    private static final String CSRF_TOKEN_URL = "/configuration/api/rest/SPACES";
    public static final String ERROR_PARAMS_MSG_4 = "Conflicting instructions. If parameter {0} is specified then parameter {1} must be specified too.";
    public static final String ERROR_PARAMS_MSG_3 = "Conflicting instructions. Specify either {0} or {1} but not both. Use {0} when targeting an application in your account. Use {1} when targeting an application provided to you by a third party; in this case specify {2} too.";
    public static final String ERROR_PARAMS_MSG_2 = "Conflicting instructions. Specify either {0} or {1} but not both. Use {1} in combination with {2}";
    public static final String ERROR_PARAMS_MSG_1 = "Conflicting instructions. When using the complex form of {0}, the value must be in format <provider_account>:<provider_application>";
    @Parameter(names={"-a", "-account", "--account"}, description="Name of the account for which you provide user and password", validateWith=SACValidator.class)
    protected String account;
    @Parameter(names={"-b", "-application", "--application"}, description="Name of the application you want to manage, configure, or deploy")
    protected String application;
    @Parameter(names={"-provider-account", "--provider-account"}, description="Refers to the account providing an application specified with the --provider-application parameter. Required if configuring a provider application.", hidden=true)
    protected String providerAccount;
    @Parameter(names={"-provider-application", "--provider-application"}, description="Refers to an application provided by the account specified with the --provider-account parameter. Required if provider account is specified.", hidden=true)
    protected String providerApplication;
    @Parameter(names={"-tenant", "--tenant"}, description="Tenant id", hidden=true)
    protected String tenant;
    @Parameter(names={"-all-subscriptions", "--all-subscriptions"}, description="Command is executed at application level", hidden=true)
    protected boolean allSubscriptions;
    protected static HttpClient httpclient = null;
    private static HttpClient testHttpClient = null;
    protected Map<String, String> errorMappings = new HashMap<String, String>();

    public static void setTestHttpClient(HttpClient testHttpClient) {
        KeyStoreCommand.testHttpClient = testHttpClient;
    }

    @Override
    public void init() throws CommandException {
        this.initWithNoPasswordCheck();
        this.checkParams();
        this.errorMappings.put(("java.io.FileNotFoundException: Name tenant for account " + this.account + " Not found. Server returned: Http Code 401 and Http Body").toLowerCase(), "There is no tenant " + this.tenant + " on account " + this.account);
        this.handleComplexApplicationValue();
    }

    private void handleComplexApplicationValue() {
        int pos;
        if (this.hasValue(this.application) && (pos = this.application.indexOf(":")) != -1) {
            String possibleProviderAccount = this.application.substring(0, pos);
            if (!this.hasValue(possibleProviderAccount)) {
                throw new ParameterException(MessageFormat.format(ERROR_PARAMS_MSG_1, "--application"));
            }
            String possibleProviderApplication = this.application.substring(pos + 1);
            if (!this.hasValue(possibleProviderApplication)) {
                throw new ParameterException(MessageFormat.format(ERROR_PARAMS_MSG_1, "--application"));
            }
            if (!possibleProviderAccount.equals(this.account)) {
                this.application = null;
                this.providerAccount = possibleProviderAccount;
                this.providerApplication = possibleProviderApplication;
            } else {
                this.providerAccount = null;
                this.providerApplication = null;
                this.account = possibleProviderAccount;
                this.application = possibleProviderApplication;
            }
        }
    }

    private void checkParams() throws CommandException {
        this.checkMandatoryParameter(this.account, "--account");
        if (this.providerAccount != null && this.application != null) {
            throw new ParameterException(MessageFormat.format(ERROR_PARAMS_MSG_2, "--application", "--provider-account", "--provider-application"));
        }
        if (this.providerApplication != null && this.application != null) {
            throw new ParameterException(MessageFormat.format(ERROR_PARAMS_MSG_3, "--application", "--provider-application", "--provider-account"));
        }
        if (this.providerAccount != null && this.providerApplication == null) {
            throw new ParameterException(MessageFormat.format(ERROR_PARAMS_MSG_4, "--provider-account", "--provider-application"));
        }
        if (this.providerAccount == null && this.providerApplication != null) {
            throw new ParameterException(MessageFormat.format(ERROR_PARAMS_MSG_4, "--provider-application", "--provider-account"));
        }
        if (this.allSubscriptions && this.tenant != null) {
            throw new ParameterException(MessageFormat.format(ERROR_PARAMS_MSG_2, "--tenant", "--all-subscriptions", "--application"));
        }
        if (this.allSubscriptions && this.application == null) {
            throw new ParameterException(MessageFormat.format(ERROR_PARAMS_MSG_4, "--all-subscriptions", "--application"));
        }
    }

    protected static HttpClient createHttpClient(String url, String userName, String password, String fetchTokenUrl) throws IOException {
        if (testHttpClient != null) {
            return testHttpClient;
        }
        if (httpclient == null) {
            httpclient = BasicAuthHttpClientProvider.createCsrfHttpClient(url, userName, password, fetchTokenUrl);
        }
        return httpclient;
    }

    protected static HttpClient createHttpClient(String url, String userName, String password) throws IOException {
        if (testHttpClient != null) {
            return testHttpClient;
        }
        if (httpclient == null) {
            httpclient = LogonUtils.createHttpClient(url, userName, password);
        }
        return httpclient;
    }

    protected static void releaseHttpClient() {
        if (httpclient != null && httpclient instanceof DefaultHttpClient) {
            httpclient.getConnectionManager().shutdown();
        }
        if (testHttpClient != null && testHttpClient instanceof DefaultHttpClient) {
            testHttpClient.getConnectionManager().shutdown();
        }
    }

    @Override
    public void cleanup() throws CommandException {
        KeyStoreCommand.releaseHttpClient();
    }

    @Override
    public String getGroup() {
        return "keystore";
    }

    protected void checkMandatoryParameter(String parameterValue, String parameterName) {
        if (parameterValue == null || parameterName.trim().length() < 1) {
            throw new ParameterException("Missing required parameter: " + parameterName);
        }
    }

    protected String formKeystoreServicePath(String keystoreName) {
        if (this.host.startsWith("http://")) {
            throw new CommandException("The parameter --host must start with 'https://'", 306);
        }
        String realHost = this.host;
        if (this.host.startsWith("https://")) {
            if (!this.host.startsWith("https://configapi")) {
                realHost = "https://configapi." + this.host.substring("https://".length());
            }
        } else {
            realHost = "https://configapi." + this.host;
        }
        if (realHost.endsWith("/")) {
            realHost = realHost.substring(0, realHost.length() - 1);
        }
        if (keystoreName == null) {
            keystoreName = "";
        }
        StringBuilder builder = new StringBuilder();
        builder.append(realHost);
        builder.append("/configuration/api/rest/");
        if (this.allSubscriptions) {
            builder.append("v2/account/");
        } else {
            builder.append("SPACES");
            builder.append('/');
        }
        builder.append(this.account);
        if (this.allSubscriptions) {
            builder.append(this.getApplicationPath(this.application));
        } else if (this.hasValue(this.application)) {
            builder.append(this.getSubscribedApplicationPath(this.application));
        } else if (this.hasValue(this.providerApplication)) {
            builder.append(this.getCrossAccountSubscribedApplicationPath(this.providerAccount, this.providerApplication));
        } else {
            if (this.hasValue(this.tenant)) {
                builder.append("/tenants/");
                builder.append(this.tenant);
            }
            builder.append("/keystore");
        }
        builder.append('/' + keystoreName);
        return builder.toString();
    }

    protected String getCsrfTokenUrl() {
        String fetchTokenUrl = null;
        fetchTokenUrl = this.host.startsWith("https://") ? (this.host.startsWith("https://configapi") ? this.host + CSRF_TOKEN_URL : "https://configapi." + this.host.substring("https://".length()) + CSRF_TOKEN_URL) : "https://configapi." + this.host + CSRF_TOKEN_URL;
        return fetchTokenUrl;
    }

    private String getApplicationPath(String appName) {
        return "/application/" + appName + "/keystore";
    }

    private String getSubscribedApplicationPath(String appName) {
        return "/appliances/" + appName + (this.hasValue(this.tenant) ? "/tenants/" + this.tenant : "/default") + "/keystore";
    }

    private String getCrossAccountSubscribedApplicationPath(String providerAccount, String providerApplication) {
        return this.getSubscribedApplicationPath(providerApplication) + "/provideraccount/" + providerAccount + "/providerapplication/" + providerApplication;
    }

    protected boolean hasValue(String val) {
        return val != null && val.length() > 0;
    }

    protected String parseResponseErrorContent(String htmlContent) {
        String errorMapping;
        int dashIndex;
        String headerBegin = "<h1>";
        String headerEnd = "</h1>";
        String responseDetailedError = htmlContent;
        String lowerCaseContent = htmlContent.toLowerCase();
        if (lowerCaseContent.contains(headerBegin) && lowerCaseContent.contains(headerEnd)) {
            responseDetailedError = htmlContent.substring(lowerCaseContent.indexOf(headerBegin) + 4, lowerCaseContent.indexOf(headerEnd));
        }
        if (responseDetailedError.startsWith("HTTP Status") && (dashIndex = responseDetailedError.indexOf("-")) > 0) {
            responseDetailedError = responseDetailedError.substring(dashIndex + 1).trim();
        }
        if ((errorMapping = this.errorMappings.get(responseDetailedError.toLowerCase())) != null) {
            responseDetailedError = errorMapping;
        }
        return responseDetailedError;
    }

    protected String getContentMessage(HttpEntity resEntity) throws IOException {
        ByteArrayOutputStream entityStream = new ByteArrayOutputStream();
        resEntity.writeTo(entityStream);
        String fullMessage = new String(entityStream.toByteArray(), resEntity.getContentEncoding() != null ? resEntity.getContentEncoding().getValue() : "UTF-8");
        return fullMessage;
    }

    protected void printSuccess(String operationName) {
        System.out.println("\nOperation " + operationName + " finished successfully.\n");
    }

    protected void checkStatusCode(int code, String message, String operationName, String additionalErrorMessage) {
        if (code != 200) {
            String text = (additionalErrorMessage != null ? additionalErrorMessage : "") + message;
            switch (code) {
                case 403: {
                    text = text + " The user " + this.user + " is not authorized for " + operationName + " operation.";
                    break;
                }
                case 503: {
                    text = text + ". Make sure the host name is correct, or contact system administrators for further support" + Constants.LINE_SEPARATOR;
                    break;
                }
                case 401: {
                    text = text + "Wrong user name or password";
                    break;
                }
                default: {
                    text = text + "Error response received. Response code: " + code;
                }
            }
            throw new CommandException(text);
        }
        this.printSuccess(operationName);
    }

    protected void processResponse(HttpResponse response, String additionalErrorMessage) throws IOException {
        HttpEntity resEntity = response.getEntity();
        int statusCode = response.getStatusLine().getStatusCode();
        String statusMessage = response.getStatusLine().getReasonPhrase();
        if (statusCode != 200) {
            String fullMessage = this.getContentMessage(resEntity);
            this.checkStatusCode(statusCode, this.parseResponseErrorContent(fullMessage), this.getName(), additionalErrorMessage);
        } else {
            this.checkStatusCode(statusCode, statusMessage, this.getName(), null);
        }
        EntityUtils.consume(resEntity);
    }
}

