/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.crypto.keystore.cmd;

import com.beust.jcommander.Parameters;
import com.sap.cloud.crypto.keystore.cmd.KeyStoreCommand;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.util.EntityUtils;

@Parameters(commandDescription="List available keystores")
public class ListKeyStores
extends KeyStoreCommand {
    private static final String INDENT = "  ";

    @Override
    public void run() throws CommandException {
        this.askForPassword();
        String path = this.formKeystoreServicePath(null);
        HttpGet request = new HttpGet(path);
        try {
            HttpClient client = ListKeyStores.createHttpClient(request.getURI().toString(), this.user, this.password);
            HttpResponse response = client.execute(request);
            if (response.getStatusLine().getStatusCode() == 200) {
                String keystoreList = this.getKeyStoresList(this.getContentMessage(response.getEntity()));
                System.out.println("\nKeystore names:");
                System.out.println(keystoreList);
                this.printSuccess(this.getName());
                EntityUtils.consume(response.getEntity());
            } else {
                this.processResponse(response, null);
            }
        }
        catch (IOException e) {
            throw new CommandException(e);
        }
        finally {
            this.cleanup();
        }
    }

    @Override
    public String getName() {
        return "list-keystores";
    }

    private String getKeyStoresList(String restApiInput) throws IOException {
        BufferedReader reader = new BufferedReader(new StringReader(restApiInput));
        String line = null;
        StringBuffer sb = new StringBuffer();
        while ((line = reader.readLine()) != null) {
            sb.append(INDENT).append(line).append("\n");
        }
        return sb.toString();
    }
}

