/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.crypto.keystore.cmd;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameters;
import com.sap.cloud.crypto.keystore.cmd.KeyStoreCommand;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.HashSet;
import java.util.Set;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.util.EntityUtils;

@Parameters(commandDescription="Upload keystore file. The name of the uploaded keystore will be the name of the file without the file extension")
public class UploadKeyStore
extends KeyStoreCommand {
    private static final String INVALID_PEM_MESSAGE = "The given keystore does not contain any correctly encoded PEM entries";
    private static final String INVALID_JKS_MESSAGE = "Given data is not a valid JKS keystore";
    @Parameter(names={"-l", "--location"}, description="Path to a keystore file on a local file system, which has to be uploaded")
    protected String localpath;
    @Parameter(names={"-w", "--overwrite"}, description="Overwrite the keystore if already exists")
    protected boolean overwrite;

    @Override
    public String getName() {
        return "upload-keystore";
    }

    @Override
    public void run() throws CommandException {
        this.checkMandatoryParameter(this.localpath, "--location");
        File file = this.getLocalFile(this.localpath);
        String errorMessage = "File " + file.getAbsolutePath() + " is not a valid keystore";
        this.errorMappings.put(INVALID_JKS_MESSAGE.toLowerCase(), errorMessage);
        this.errorMappings.put(INVALID_PEM_MESSAGE.toLowerCase(), errorMessage);
        String keyStoreName = this.getKeystoreName(file);
        this.askForPassword();
        if (this.keyStoreAlreadyExists(keyStoreName) && !this.overwrite) {
            System.out.println("Warning: Keystore " + keyStoreName + " already exists. To replace it, run the command with parameter -w (--overwrite).");
            return;
        }
        String path = this.formKeystoreServicePath(null);
        try {
            HttpPost request = new HttpPost(path);
            HashSet<String> files = new HashSet<String>();
            files.add(file.getAbsolutePath());
            this.upload(request, files);
        }
        catch (IOException e) {
            throw new CommandException(e);
        }
    }

    private File getLocalFile(String pathname) throws CommandException {
        File file = new File(pathname);
        if (!file.exists()) {
            throw new ParameterException("Invalid value in parameter --location. File '" + pathname + "' was not found");
        }
        if (file.isDirectory()) {
            throw new ParameterException("Invalid value in parameter --location. '" + pathname + "' points to a directory");
        }
        if (file.length() > 0x100000L) {
            throw new ParameterException("Invalid value in parameter --location. The size of the provided file [" + pathname + "] " + "is larger than the limit of " + 1L + " megabyte(s)");
        }
        return file;
    }

    private String getKeystoreName(File localKeystoreFile) {
        String fileName = localKeystoreFile.getName();
        int extensionSeparatorIndex = fileName.lastIndexOf(".");
        if (extensionSeparatorIndex == -1 || extensionSeparatorIndex == fileName.length() - 1) {
            throw new ParameterException("Invalid value in parameter --location. The file must have an extension");
        }
        if (extensionSeparatorIndex == 0) {
            throw new ParameterException("Invalid value in parameter --location. File does not have name");
        }
        return fileName.substring(0, extensionSeparatorIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void upload(HttpPost request, Set<String> files) throws IOException {
        if (files != null && !files.isEmpty()) {
            try {
                String fetchTokenUrl = this.getCsrfTokenUrl();
                HttpClient client = UploadKeyStore.createHttpClient(request.getURI().toString(), this.user, this.password, fetchTokenUrl);
                MultipartEntity reqEntity = new MultipartEntity();
                for (String filename : files) {
                    File file = new File(filename);
                    FileBody body = new FileBody(file);
                    reqEntity.addPart(file.getName(), body);
                }
                request.setEntity(reqEntity);
                HttpResponse response = client.execute(request);
                this.processResponse(response, null);
            }
            finally {
                this.cleanup();
            }
        }
    }

    private boolean keyStoreAlreadyExists(String keystoreName) throws CommandException {
        boolean result = false;
        try {
            String path = this.formKeystoreServicePath(null);
            String fetchTokenUrl = this.getCsrfTokenUrl();
            HttpGet request = new HttpGet(path);
            HttpClient client = UploadKeyStore.createHttpClient(request.getURI().toString(), this.user, this.password, fetchTokenUrl);
            HttpResponse response = client.execute(request);
            if (response.getStatusLine().getStatusCode() == 200) {
                String line;
                String responseStr = this.getContentMessage(response.getEntity());
                BufferedReader reader = new BufferedReader(new StringReader(responseStr));
                while ((line = reader.readLine()) != null) {
                    if (!line.trim().equals(keystoreName)) continue;
                    result = true;
                    break;
                }
                EntityUtils.consume(response.getEntity());
            } else {
                this.processResponse(response, "Error occurred while trying to check if the keystore already exist: ");
            }
        }
        catch (IOException e) {
            throw new CommandException("Error occurred while trying to check if the keystore already exist", e);
        }
        finally {
            this.cleanup();
        }
        return result;
    }
}

