/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ecm.consolecommands;

import com.beust.jcommander.Parameter;
import com.sap.ecm.consolecommands.HttpClientProvider;
import com.sap.jpaas.infrastructure.console.command.RemoteCommand;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import com.sap.jpaas.infrastructure.console.util.CheckHelper;
import com.sap.jpaas.infrastructure.console.validator.SACValidator;

public abstract class AbstractCommand
extends RemoteCommand {
    @Parameter(names={"--service"}, description="(Optional) Name of the service", hidden=true, required=false)
    private String serviceName;
    @Parameter(names={"--tunnel"}, description="(Optional) URL prefix for command tunnel (short url)", hidden=true, required=false)
    private String cmdTunnelUrl;
    @Parameter(names={"-a", "-account", "--account"}, description="Name of the account for which you provide user and password", validateWith=SACValidator.class)
    private String account;

    protected static String getURL(String urlStart, String repositoryNameParameter, String tenantIdParameter) {
        StringBuffer url = new StringBuffer(urlStart);
        if (repositoryNameParameter != null && !"".equals(repositoryNameParameter)) {
            url.append(HttpClientProvider.encodeURLString(repositoryNameParameter));
        }
        if (tenantIdParameter != null) {
            if (repositoryNameParameter == null || "".equals(repositoryNameParameter)) {
                throw new CommandException("Parameter -t/--tenant can only be used in combination with parameter -n/--name");
            }
            url.append('/');
            url.append("tenants/");
            url.append(HttpClientProvider.encodeURLString(tenantIdParameter));
        }
        return url.toString();
    }

    public final String getServiceName() {
        return this.serviceName;
    }

    public final String getTunnelUrl() {
        return this.cmdTunnelUrl;
    }

    public final String getAccount() {
        return this.account;
    }

    private final void checkArgAccount() {
        CheckHelper.checkArgSpecified((String)"-a", (String)"--account", (String)this.getAccount());
    }

    public final String getGroup() {
        return "document-service";
    }

    public final void init() throws CommandException {
        this.checkArgs();
        super.init();
    }

    protected void checkArgs() {
        this.checkArgAccount();
    }

    public final void cleanup() throws CommandException {
    }

    public abstract void run() throws CommandException;

    protected boolean confirmMessage() {
        return true;
    }
}

