/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ecm.consolecommands;

import com.google.gson.Gson;
import com.sap.ecm.consolecommands.AbstractCommand;
import com.sap.ecm.consolecommands.AbstractCommandRepository;
import com.sap.ecm.consolecommands.HttpClientProvider;
import com.sap.ecm.consolecommands.HttpResponseContext;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Locale;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;
import org.apache.log4j.Logger;

public class CommandTunnelRequestExecutor {
    private static final String ORG_APACHE_CXF_INTERCEPTOR_FAULT = "org.apache.cxf.interceptor.Fault: ";
    private static final String MIME_TYPE_APPLICATION_JSON = "application/json";
    private static final String B_MESSAGE_B_U = "<b>message</b> <u>";
    private Logger LOGGER = Logger.getLogger(CommandTunnelRequestExecutor.class);
    private AbstractCommand command;
    private final String cmdUrlPath;
    private String httpMethod;
    private String cmdTunnelShortUrl;
    private HashMap<String, Object> parameters;

    public CommandTunnelRequestExecutor(String httpMethod, AbstractCommand command, String psaApiPath, String cmdTunnelShortUrl) {
        this(httpMethod, command, psaApiPath, cmdTunnelShortUrl, null);
    }

    public CommandTunnelRequestExecutor(String httpMethod, AbstractCommand command, String psaApiPath, String cmdTunnelShortUrl, HashMap<String, Object> parameters) {
        this.httpMethod = httpMethod;
        this.cmdUrlPath = psaApiPath;
        this.command = command;
        this.cmdTunnelShortUrl = cmdTunnelShortUrl;
        this.parameters = parameters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeRequest() throws CommandException {
        String rc = null;
        if (this.LOGGER.isInfoEnabled()) {
            this.LOGGER.info((Object)(CommandTunnelRequestExecutor.class.getSimpleName() + ".executeRequest() called for command [" + this.command.getName() + "]"));
        }
        System.out.println("");
        this.validateHost();
        HttpClient httpClient = null;
        try {
            HttpResponse response;
            httpClient = this.getClientWithBasicAuth();
            HttpUriRequest httpUriRequest = this.getHttpUriRequest(this.httpMethod, this.getRequestUri());
            this.LOGGER.debug((Object)(" Request URI: " + httpUriRequest.getURI().toString()));
            try {
                response = httpClient.execute(httpUriRequest);
            }
            catch (UnknownHostException e) {
                throw new CommandException((Throwable)new UnknownHostException(httpUriRequest.getURI().toString()), 255);
            }
            if (response == null) {
                this.LOGGER.error((Object)("Internal error: Response of " + httpUriRequest.toString() + " is empty."));
                throw new CommandException("Failed due to an internal error", 255);
            }
            if (response.getStatusLine() == null) {
                this.LOGGER.error((Object)(" Internal error: Response StatusLine of " + httpUriRequest.toString() + " empty."));
                throw new CommandException("Failed due to internal error", 255);
            }
            rc = this.consume(new HttpResponseContext(response, httpUriRequest, this.command));
        }
        catch (CommandException e) {
            throw e;
        }
        catch (Exception e) {
            this.wrappAndThrowCommandException("Unexpected exception occurred", e, 255);
        }
        finally {
            if (httpClient != null && httpClient.getConnectionManager() != null) {
                httpClient.getConnectionManager().shutdown();
            }
        }
        return rc;
    }

    String getRequestUri() {
        String serviceName = this.command.getServiceName();
        if (serviceName == null || serviceName.length() == 0) {
            serviceName = "ecm";
        }
        String serviceUriPath = "/services/v1/instances/" + this.command.getAccount() + "/" + serviceName + "/" + "v1" + "/" + this.cmdUrlPath;
        return this.getRequestUri(this.command.getHost(), serviceUriPath);
    }

    String getRequestUri(String host, String serviceUriPath) {
        String cmdTunnelUrl = null == this.cmdTunnelShortUrl || this.cmdTunnelShortUrl.length() == 0 ? "services" : this.cmdTunnelShortUrl;
        String result = CommandTunnelRequestExecutor.getCommandTunnelHost(host, cmdTunnelUrl);
        result = serviceUriPath.startsWith("/") ? result + serviceUriPath.substring(1) : result + serviceUriPath;
        return result;
    }

    static String getCommandTunnelHost(String host, String cmdTunnelUrl) {
        host = host.toLowerCase(Locale.ENGLISH);
        String currentHttpsPrefix = null;
        if (host.startsWith("https://")) {
            currentHttpsPrefix = "https://";
        } else if (host.startsWith("http://")) {
            currentHttpsPrefix = "http://";
        } else {
            throw new CommandException("Host '" + host + "' does not start with '" + "https://" + "' or with '" + "http://" + "'.", 255);
        }
        String result = currentHttpsPrefix + cmdTunnelUrl + "." + host.substring(currentHttpsPrefix.length());
        if (!result.endsWith("/")) {
            result = result + "/";
        }
        return result;
    }

    HttpClient getClientWithBasicAuth() throws URISyntaxException, MalformedURLException, ClientProtocolException, IOException {
        return HttpClientProvider.createClientWithBasicAuth(this.command.getUser(), this.command.getPassword(), this.getRequestUri());
    }

    private void wrappAndThrowCommandException(String newMsg, Exception cause, int exitCode) {
        throw new CommandException(newMsg, (Throwable)new Exception(newMsg, cause), exitCode);
    }

    void validateHost() {
        String host = this.command.getHost();
        HttpClientProvider.validateHost(host);
    }

    private HttpUriRequest getHttpUriRequest(String httpMethod, String url) {
        if (httpMethod.equalsIgnoreCase("GET")) {
            return new HttpGet(url);
        }
        if (httpMethod.equalsIgnoreCase("POST")) {
            return this.setStringEntity((HttpEntityEnclosingRequestBase)new HttpPost(url));
        }
        if (httpMethod.equalsIgnoreCase("PUT")) {
            return this.setStringEntity((HttpEntityEnclosingRequestBase)new HttpPut(url));
        }
        if (httpMethod.equalsIgnoreCase("DELETE")) {
            HttpDelete httpDelete = new HttpDelete(url);
            return this.setStringEntity(httpDelete);
        }
        return null;
    }

    private HttpUriRequest setStringEntity(HttpDelete httpDelete) {
        Object repositorykey;
        httpDelete.addHeader("Content-Type", "application/json;charset=utf-8");
        if (this.parameters != null && (repositorykey = this.parameters.get("-k")) != null) {
            BasicHttpParams params = new BasicHttpParams();
            params.setParameter("X-EcmRepKeyEnc", (Object)repositorykey.toString());
            httpDelete.setParams((HttpParams)params);
            httpDelete.addHeader("X-EcmRepKeyEnc", repositorykey.toString());
        }
        return httpDelete;
    }

    private HttpUriRequest setStringEntity(HttpEntityEnclosingRequestBase httpRequest) {
        if (this.parameters != null) {
            Gson gson = new Gson();
            String json = gson.toJson(this.parameters);
            try {
                StringEntity stringEntity = new StringEntity(json, MIME_TYPE_APPLICATION_JSON, "UTF-8");
                stringEntity.setContentType("application/json;charset=utf-8");
                stringEntity.setContentEncoding("UTF-8");
                httpRequest.setEntity((HttpEntity)stringEntity);
            }
            catch (UnsupportedEncodingException ex) {
                this.LOGGER.error((Object)"Error in building Json entity for request.", (Throwable)ex);
                throw new CommandException("Error creating request.", (Throwable)ex, 255);
            }
        }
        return httpRequest;
    }

    private String consume(HttpResponseContext context) throws CommandException {
        String msg = null;
        int statusCode = context.getStatusCode();
        if (statusCode == 401) {
            msg = "The identity of user " + context.getCommand().getUser() + " could not be verified for " + context.getHttpUriRequest().getURI().toString() + ".\n" + "Please verify the supplied user name and password and execute the command again.";
        } else if (statusCode == 500) {
            msg = "An internal server error occurred.";
        } else if (statusCode == 503) {
            msg = "The server " + context.getHttpUriRequest().getURI().toString() + " is unavailable.";
        } else if (statusCode == 404) {
            if (context.getCommand() instanceof AbstractCommandRepository) {
                AbstractCommandRepository cmd = (AbstractCommandRepository)context.getCommand();
                msg = "Config entry with unique name " + cmd.getRepositoryName() + " does not exist.";
            } else {
                msg = "The uri " + context.getHttpUriRequest().getURI().toString() + " is not found.";
            }
        } else if (statusCode == 403) {
            msg = context.getResponseContentString();
            if (msg == null || msg.startsWith("<html")) {
                msg = "Authorization error - the execution was rejected.";
            }
        } else if (statusCode == 401) {
            msg = context.getResponseContentString();
            if (msg == null || msg.startsWith("<html")) {
                msg = "Authorization error - Invalid authentication credentials for the target resource.";
            }
        } else if (statusCode == 408 || statusCode == 504) {
            msg = "Request timeout for " + context.getHttpUriRequest().getURI().toString() + ".";
        } else if (statusCode >= 400 && (msg = context.getResponseContentString()) == null) {
            msg = "An unexpected internal problem occurred.";
        }
        if (msg != null) {
            this.throwCommandExceptionWithContentInfoAndLog(msg, context);
        }
        if (this.LOGGER.isDebugEnabled()) {
            this.LOGGER.debug((Object)("Command " + context.getHttpUriRequest().getURI() + " executed, response code: " + statusCode));
        }
        return context.getResponseContentString();
    }

    private void throwCommandExceptionWithContentInfoAndLog(String detailMsg, HttpResponseContext context) {
        this.throwCommandExceptionWithContentInfoAndLog(detailMsg, null, context);
    }

    private void throwCommandExceptionWithContentInfoAndLog(String detailMsg, String additionalLogMessage, HttpResponseContext context) {
        this.logResponseContent(detailMsg, additionalLogMessage, context);
        String exceptionMsg = detailMsg == null || detailMsg.trim().length() == 0 ? "" : detailMsg;
        String responseContentTypeValue = context.getResponseContentTypeValue();
        if (responseContentTypeValue != null) {
            String responseContentString;
            int indexOf;
            if (responseContentTypeValue.startsWith("text/plain")) {
                String responseContentString2 = context.getResponseContentString();
                if (responseContentString2 != null) {
                    if (exceptionMsg.length() > 0) {
                        exceptionMsg = exceptionMsg + "\n";
                    }
                    exceptionMsg = exceptionMsg + responseContentString2;
                }
            } else if (responseContentTypeValue.startsWith("text/html") && (indexOf = (responseContentString = context.getResponseContentString()).indexOf(B_MESSAGE_B_U)) > 0) {
                int indexOfEnd = responseContentString.indexOf("</u>", indexOf);
                exceptionMsg = responseContentString.substring(indexOf + B_MESSAGE_B_U.length(), indexOfEnd);
                if (exceptionMsg.startsWith(ORG_APACHE_CXF_INTERCEPTOR_FAULT)) {
                    exceptionMsg = exceptionMsg.substring(ORG_APACHE_CXF_INTERCEPTOR_FAULT.length());
                }
            }
        }
        throw new CommandException("".equals(exceptionMsg) ? detailMsg : exceptionMsg, 255);
    }

    private void logResponseContent(String detailedMsg, String additionalLogMessage, HttpResponseContext context) {
        this.LOGGER.error((Object)detailedMsg);
        if (additionalLogMessage != null) {
            this.LOGGER.error((Object)additionalLogMessage);
        }
        this.LOGGER.error((Object)("request URI: " + context.getHttpUriRequest().getURI().toString()));
        this.LOGGER.error((Object)("request URI method: " + context.getHttpUriRequest().getMethod()));
        this.LOGGER.error((Object)("statusCode: " + context.getStatusCode() + " " + this.getStatusCodeDetailMsg(context)));
        this.LOGGER.error((Object)("contentType: " + context.getResponseContentTypeValue()));
        this.LOGGER.error((Object)("content: " + context.getResponseContentString()));
    }

    private String getStatusCodeDetailMsg(HttpResponseContext context) {
        if (context.getStatusCode() == 400) {
            return "SC_BAD_REQUEST : Server could not understand the request due to invalid syntax.";
        }
        if (context.getStatusCode() == 502) {
            return "SC_BAD_GATEWAY : Server got an invalid Response";
        }
        if (context.getStatusCode() == 403) {
            return "SC_FORBIDDEN : Client does not have access rights to the content";
        }
        if (context.getStatusCode() == 404) {
            return "SC_NOT_FOUND : Requested resource is not found";
        }
        if (context.getStatusCode() == 401) {
            return "SC_UNAUTHORIZED: Invalid authentication credentials for the target resource.";
        }
        if (context.getStatusCode() == 500) {
            return "SC_INTERNAL_SERVER_ERROR : The server encountered an unexpected condition.";
        }
        if (context.getStatusCode() == 503) {
            return "SC_SERVICE_UNAVAILABLE : The server is not ready to handle the request";
        }
        if (context.getStatusCode() == 504) {
            return "SC_GATEWAY_TIMEOUT : Timeout Error";
        }
        return "";
    }
}

