/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ecm.consolecommands;

import com.sap.core.utils.infrastructure.validation.LandscapeHostValidator;
import com.sap.core.utils.infrastructure.validation.ValidationStatus;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.ProxySelector;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.ProxySelectorRoutePlanner;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.log4j.Logger;

public class HttpClientProvider {
    private static Logger LOGGER = Logger.getLogger(HttpClientProvider.class);
    private static HttpClientProvider instance;

    private static HttpClientProvider getInstance() {
        if (instance == null) {
            instance = new HttpClientProvider();
        }
        return instance;
    }

    public static HttpClient createClientWithBasicAuth(String username, String password, String url) throws URISyntaxException, MalformedURLException {
        return HttpClientProvider.getInstance().createClientWithBasicAuthentication(username, password, url);
    }

    protected HttpClient createClientWithBasicAuthentication(String username, String password, String url) throws URISyntaxException, MalformedURLException {
        DefaultHttpClient defaultHttpClient = this.getHttpClientWithSystemProxySettings();
        URI uri = new URI(url);
        if (uri.getScheme() == null) {
            throw new IllegalArgumentException("Cannot create http client because the supplied host URL [" + url + "] doesn't contain scheme");
        }
        AuthScope authscope = this.getScope(url);
        Credentials credentials = this.getCredentials(username, password);
        defaultHttpClient.getCredentialsProvider().setCredentials(authscope, credentials);
        return defaultHttpClient;
    }

    private AuthScope getScope(String urlString) throws MalformedURLException {
        URL url = new URL(urlString);
        return new AuthScope(url.getHost(), url.getPort());
    }

    private Credentials getCredentials(String username, String password) {
        UsernamePasswordCredentials credentials = null;
        if (username != null && password != null) {
            credentials = new UsernamePasswordCredentials(username, password);
        }
        return credentials;
    }

    private DefaultHttpClient getHttpClientWithSystemProxySettings() {
        DefaultHttpClient httpClient = new DefaultHttpClient((ClientConnectionManager)new ThreadSafeClientConnManager());
        ProxySelectorRoutePlanner routePlanner = new ProxySelectorRoutePlanner(httpClient.getConnectionManager().getSchemeRegistry(), ProxySelector.getDefault());
        httpClient.setRoutePlanner((HttpRoutePlanner)routePlanner);
        return httpClient;
    }

    public static String encodeURLString(String inputString) throws CommandException {
        try {
            return URLEncoder.encode(inputString, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new CommandException("Failed to encode " + inputString, (Throwable)e, 255);
        }
    }

    public static void validateHost(String host) {
        HttpClientProvider.getInstance().validateHostInternal(host);
    }

    protected void validateHostInternal(String host) {
        try {
            ValidationStatus status = LandscapeHostValidator.isLandscapeHostValid((String)host, (String)"");
            if (status.isError()) {
                LOGGER.error((Object)("Host [" + host + "] cannot be reached. Original error message is: " + status.getMessage()), (Throwable)status.getException());
                throw new CommandException(status.getMessage(), (Throwable)status.getException(), 255);
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)("Host [" + host + "] cannot be validated. Original error message is: " + e.getMessage()), (Throwable)e);
            throw new CommandException(e.getMessage(), (Throwable)e, 255);
        }
    }
}

