/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ecm.consolecommands.impl;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.sap.ecm.consolecommands.AbstractCommandRepositoryKey;
import com.sap.ecm.consolecommands.CommandTunnelRequestExecutor;
import com.sap.ecm.consolecommands.HttpClientProvider;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import com.sap.jpaas.infrastructure.console.util.CheckHelper;
import java.util.HashMap;

@Parameters(commandDescription="Adds a new tenant to a repository")
public class AddTenant
extends AbstractCommandRepositoryKey {
    public static final String ECM_COMMAND_NAME = "add-ecm-tenant";
    @Parameter(names={"-t", "--tenant"}, description="Tenant alias")
    protected String tenantId;
    @Parameter(names={"-v", "--virus-scan"}, description="(Optional) Virus scan status [true|false]", hidden=false, required=false)
    private String virusScanStatus;

    public final String getTenantId() {
        return this.tenantId;
    }

    @Override
    protected void checkArgs() {
        this.checkArgTenant();
        super.checkArgs();
    }

    private void checkArgTenant() {
        CheckHelper.checkArgSpecified((String)"-t", (String)"--tenant", (String)this.getTenantId());
    }

    public Boolean getVirusScanStatus() {
        return Boolean.valueOf(this.virusScanStatus);
    }

    public String getName() {
        return ECM_COMMAND_NAME;
    }

    @Override
    public void run() throws CommandException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("key", this.getRepositoryKey());
        parameters.put("tenantAlias", this.getTenantId());
        if (this.getVirusScanStatus() != null) {
            parameters.put("virusScanStatus", this.getVirusScanStatus());
        }
        String url = "repositories/" + HttpClientProvider.encodeURLString(this.getRepositoryName()) + "/" + "tenants/";
        CommandTunnelRequestExecutor cmdExecutor = new CommandTunnelRequestExecutor("POST", this, url, this.getTunnelUrl(), parameters);
        cmdExecutor.executeRequest();
        System.out.println("Tenant \"" + this.getTenantId() + "\" added to repository \"" + this.getRepositoryName() + "\".");
    }
}

