/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ecm.consolecommands.impl;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.sap.ecm.consolecommands.AbstractCommandRepositoryKey;
import com.sap.ecm.consolecommands.CommandTunnelRequestExecutor;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import java.util.HashMap;

@Parameters(commandDescription="Creates a new repository")
public class Create
extends AbstractCommandRepositoryKey {
    public static final String ECM_COMMAND_NAME = "create-ecm-repository";
    @Parameter(names={"-d", "--display-name"}, description="(Optional) Display name", hidden=false, required=false)
    private String displayName;
    @Parameter(names={"-e", "--description"}, description="(Optional) Description", hidden=false, required=false)
    private String description;
    @Parameter(names={"-v", "--virus-scan"}, description="(Optional) Virus scan status [true|false]", hidden=false, required=false)
    private String virusScanStatus;
    @Parameter(names={"--premium-dr"}, description="(Optional) Premium Disaster Recovery [true|false]", hidden=false, required=false)
    private String premiumDisasterRecovery;

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public Boolean getVirusScanStatus() {
        return Boolean.valueOf(this.virusScanStatus);
    }

    public Boolean getPremiumDR() {
        return Boolean.valueOf(this.premiumDisasterRecovery);
    }

    public String getName() {
        return ECM_COMMAND_NAME;
    }

    @Override
    public void run() throws CommandException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("uniqueName", this.getRepositoryName());
        parameters.put("key", this.getRepositoryKey());
        parameters.put("displayName", this.getDisplayName());
        parameters.put("description", this.getDescription());
        parameters.put("applicationId", "Neo CLI");
        if (this.getVirusScanStatus() != null) {
            parameters.put("virusScanStatus", this.getVirusScanStatus());
        } else {
            parameters.put("virusScanStatus", false);
        }
        if (this.getPremiumDR() != null) {
            parameters.put("enablePdr", this.getPremiumDR());
        } else {
            parameters.put("enablePdr", false);
        }
        CommandTunnelRequestExecutor cmdExecutor = new CommandTunnelRequestExecutor("POST", this, "repositories/", this.getTunnelUrl(), parameters);
        cmdExecutor.executeRequest();
        System.out.println("Repository \"" + this.getRepositoryName() + "\" created.");
    }
}

