/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ecm.consolecommands.impl;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.sap.ecm.consolecommands.AbstractCommandRepositoryKey;
import com.sap.ecm.consolecommands.CommandTunnelRequestExecutor;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import java.io.Console;
import java.util.HashMap;
import java.util.Locale;

@Parameters(commandDescription="Deletes a repository including the data of any tenants in the repository")
public class Delete
extends AbstractCommandRepositoryKey {
    public static final String ECM_COMMAND_NAME = "delete-ecm-repository";
    @Parameter(names={"-t", "--tenant"}, description="(Optional) Tenant alias", hidden=false, required=false)
    protected String tenantId;
    @Parameter(names={"--silent"}, description="(Optional) Suppresses the command line confirmation prompt", hidden=true, required=false)
    private boolean silent = false;

    public String getName() {
        return ECM_COMMAND_NAME;
    }

    public final String getTenantId() {
        return this.tenantId;
    }

    public final boolean getSilent() {
        return this.silent;
    }

    @Override
    protected boolean confirmMessage() {
        Console cons = System.console();
        if (cons == null) {
            throw new CommandException("No console availaible. Please use parameter --silent do force the deletion.", 255);
        }
        System.out.println("Are you sure you want to permanently delete all data? This operation cannot be reverted. (yes/no) ");
        String answer = cons.readLine().toLowerCase(Locale.ENGLISH);
        return "yes".equals(answer) || "y".equals(answer);
    }

    @Override
    public void run() throws CommandException {
        if (this.getSilent() || this.confirmMessage()) {
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            parameters.put("-k", this.getRepositoryKey());
            CommandTunnelRequestExecutor cmdExecutor = new CommandTunnelRequestExecutor("DELETE", this, Delete.getURL("repositories/", this.getRepositoryName(), this.getTenantId()), this.getTunnelUrl(), parameters);
            cmdExecutor.executeRequest();
            System.out.println("Repository " + this.getRepositoryName() + " deleted.");
        }
    }
}

