/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ecm.consolecommands.impl;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.google.gson.Gson;
import com.sap.ecm.consolecommands.AbstractCommandRepository;
import com.sap.ecm.consolecommands.CommandTunnelRequestExecutor;
import com.sap.ecm.consolecommands.output.Repository;
import com.sap.ecm.consolecommands.output.Statistics;
import com.sap.ecm.consolecommands.output.Tenant;
import com.sap.jpaas.infrastructure.console.exception.CommandException;

@Parameters(commandDescription="Returns details and settings of one repository, including tenant details")
public class Display
extends AbstractCommandRepository {
    public static final String ECM_COMMAND_NAME = "display-ecm-repository";
    @Parameter(names={"-t", "--tenant"}, description="(Optional) Tenant alias", hidden=false, required=false)
    protected String tenantId;

    public String getName() {
        return ECM_COMMAND_NAME;
    }

    public final String getTenantId() {
        return this.tenantId;
    }

    @Override
    public void run() throws CommandException {
        CommandTunnelRequestExecutor cmdExecutorRepository = new CommandTunnelRequestExecutor("GET", this, Display.getURL("repositories/", this.getRepositoryName(), null), this.getTunnelUrl());
        String responseContentStringRepository = cmdExecutorRepository.executeRequest();
        CommandTunnelRequestExecutor cmdExecutorStatistics = new CommandTunnelRequestExecutor("GET", this, Display.getURL("statistics/", this.getRepositoryName(), this.getTenantId()), this.getTunnelUrl());
        String responseContentStringStatistics = cmdExecutorStatistics.executeRequest();
        String url = Display.getURL("repositories/", this.getRepositoryName(), this.getTenantId());
        Gson gson = new Gson();
        Repository repository = (Repository)gson.fromJson(responseContentStringRepository, Repository.class);
        if (this.getTenantId() == null) {
            CommandTunnelRequestExecutor cmdExecutorRepositoryTenant = new CommandTunnelRequestExecutor("GET", this, url + "/" + "tenants/", this.getTunnelUrl());
            String responseContentStringRepositoryTenant = null;
            try {
                responseContentStringRepositoryTenant = cmdExecutorRepositoryTenant.executeRequest();
                Tenant[] tenants = (Tenant[])gson.fromJson(responseContentStringRepositoryTenant, Tenant[].class);
                Statistics[] statistics = (Statistics[])gson.fromJson(responseContentStringStatistics, Statistics[].class);
                this.setTenantStatistics(tenants, statistics);
                repository.setTenants(tenants);
            }
            catch (CommandException ce) {
                repository.setTenants(new Tenant[0]);
            }
        } else {
            CommandTunnelRequestExecutor cmdExecutorRepositoryTenant = new CommandTunnelRequestExecutor("GET", this, url, this.getTunnelUrl());
            String responseContentStringRepositoryTenant = cmdExecutorRepositoryTenant.executeRequest();
            Tenant tenant = (Tenant)gson.fromJson(responseContentStringRepositoryTenant, Tenant.class);
            Statistics statistics = (Statistics)gson.fromJson(responseContentStringStatistics, Statistics.class);
            tenant.setStatistics(statistics);
            repository.setTenants(new Tenant[]{tenant});
        }
        System.out.print(repository);
    }

    private void setTenantStatistics(Tenant[] tenants, Statistics[] statistics) {
        if (tenants != null) {
            for (Tenant tenant : tenants) {
                if (statistics == null) continue;
                for (Statistics statistics2 : statistics) {
                    if (!tenant.getTenantAlias().equals(statistics2.getTenantAlias())) continue;
                    tenant.setStatistics(statistics2);
                }
            }
        }
    }
}

