/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ecm.consolecommands.impl;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.sap.ecm.consolecommands.AbstractCommandRepositoryKey;
import com.sap.ecm.consolecommands.CommandTunnelRequestExecutor;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import java.util.HashMap;

@Parameters(commandDescription="Changes the name, key or virus scan settings of a repository")
public class Edit
extends AbstractCommandRepositoryKey {
    public static final String ECM_COMMAND_NAME = "edit-ecm-repository";
    @Parameter(names={"-t", "--tenant"}, description="(Optional) Tenant alias", hidden=false, required=false)
    protected String tenantId;
    @Parameter(names={"-v", "--virus-scan"}, description="(Optional) Virus scan status [true|false]", hidden=false, required=false)
    private String virusScanStatus;
    @Parameter(names={"-q", "--newkey"}, description="(Optional) New repository key", hidden=false, required=false)
    private String newRepositoryKey;
    @Parameter(names={"-o", "--newname"}, description="(Optional) New name of the repository", hidden=false, required=false)
    private String newName;

    public String getName() {
        return ECM_COMMAND_NAME;
    }

    public final String getTenantId() {
        return this.tenantId;
    }

    public Boolean getVirusScanStatus() {
        return Boolean.valueOf(this.virusScanStatus);
    }

    public String getNewRepositoryKey() {
        return this.newRepositoryKey;
    }

    public String getNewName() {
        return this.newName;
    }

    @Override
    public void run() throws CommandException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("key", this.getRepositoryKey());
        parameters.put("virusScanStatus", this.getVirusScanStatus());
        if (this.getNewRepositoryKey() != null) {
            parameters.put("newKey", this.getNewRepositoryKey());
        }
        if (this.getNewName() != null) {
            parameters.put("newUniqueName", this.getNewName());
        }
        CommandTunnelRequestExecutor cmdExecutor = new CommandTunnelRequestExecutor("PUT", this, Edit.getURL("repositories/", this.getRepositoryName(), this.getTenantId()), this.getTunnelUrl(), parameters);
        cmdExecutor.executeRequest();
        System.out.println("edit-ecm-repository executed.");
    }
}

