/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ecm.consolecommands.impl;

import com.beust.jcommander.Parameters;
import com.google.gson.Gson;
import com.sap.ecm.consolecommands.AbstractCommand;
import com.sap.ecm.consolecommands.CommandTunnelRequestExecutor;
import com.sap.ecm.consolecommands.output.Repository;
import com.sap.jpaas.infrastructure.console.exception.CommandException;

@Parameters(commandDescription="Returns details and settings of all repositories in the specified account")
public class List
extends AbstractCommand {
    public static final String ECM_COMMAND_NAME = "list-ecm-repositories";

    public String getName() {
        return ECM_COMMAND_NAME;
    }

    @Override
    public void run() throws CommandException {
        Repository[] repositories;
        CommandTunnelRequestExecutor cmdExecutor = new CommandTunnelRequestExecutor("GET", this, List.getURL("repositories/", null, null), this.getTunnelUrl());
        String responseContentString = cmdExecutor.executeRequest();
        Gson gson = new Gson();
        for (Repository repository : repositories = (Repository[])gson.fromJson(responseContentString, Repository[].class)) {
            System.out.println(repository.toString());
            System.out.println("\n");
        }
        System.out.println("Number of Repositories: " + repositories.length);
    }
}

