/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ecm.consolecommands.impl;

import com.beust.jcommander.Parameters;
import com.google.gson.Gson;
import com.sap.ecm.consolecommands.AbstractCommandRepository;
import com.sap.ecm.consolecommands.CommandTunnelRequestExecutor;
import com.sap.ecm.consolecommands.HttpClientProvider;
import com.sap.ecm.consolecommands.output.ResetKeyInfo;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import java.util.HashMap;

@Parameters(commandDescription="Generates a new repository key that replaces the current one. Use this command in case you have forgotten the current repository key.")
public class ResetKey
extends AbstractCommandRepository {
    public static final String ECM_COMMAND_NAME = "reset-ecm-key";

    public String getName() {
        return ECM_COMMAND_NAME;
    }

    @Override
    public void run() throws CommandException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        CommandTunnelRequestExecutor cmdExecutor = new CommandTunnelRequestExecutor("POST", this, ResetKey.getURL("repositories/", this.getRepositoryName(), "key"), this.getTunnelUrl(), parameters);
        String responseContentString = cmdExecutor.executeRequest();
        Gson gson = new Gson();
        ResetKeyInfo keyInfo = (ResetKeyInfo)gson.fromJson(responseContentString, ResetKeyInfo.class);
        System.out.println("For repository " + keyInfo.uniqueName + " the new key '" + keyInfo.key + "' was created.");
    }

    protected static String getURL(String urlStart, String repositoryNameParameter, String suffix) {
        StringBuffer url = new StringBuffer(urlStart);
        if (repositoryNameParameter != null && !"".equals(repositoryNameParameter)) {
            url.append(HttpClientProvider.encodeURLString(repositoryNameParameter));
        }
        if (suffix != null) {
            url.append('/');
            url.append(HttpClientProvider.encodeURLString(suffix));
        }
        return url.toString();
    }
}

