/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.runtime.kotyo.configurator;

import com.sap.core.services.accessor.lifecycle.InternalComponentLifecycle;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnvironmentConfigurator
implements InternalComponentLifecycle {
    public static final String PROP_RUNTIME_TYPE_KEY = "runtime.type";
    public static final String PROP_RUNTIME_VERSION_KEY = "runtime.version";
    public static final String PROP_VERSION_KEY = "version";
    public static final String PROP_DISTRIBUTION_KEY = "distribution.project.name";
    public static final String PROP_CATALINA_HOME_KEY = "catalina.home";
    static String versionPropertiesFilename = "version.properties";
    private static final Logger logger = LoggerFactory.getLogger(EnvironmentConfigurator.class);
    private Properties versionProperties = null;

    public void start() {
        this.setRuntimeVersionProperty();
        this.setRuntimeTypeProperty();
    }

    public void stop() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Properties getVersionProperties() {
        if (this.versionProperties != null) {
            return this.versionProperties;
        }
        this.versionProperties = new Properties();
        String catalinaHome = System.getProperty(PROP_CATALINA_HOME_KEY);
        if (catalinaHome == null) {
            logger.error("catalina.home property is missing; cannot read " + versionPropertiesFilename);
            return this.versionProperties;
        }
        if (!catalinaHome.endsWith(File.separator)) {
            catalinaHome = catalinaHome + File.separator;
        }
        InputStream versionPropertiesStream = null;
        try {
            versionPropertiesStream = new FileInputStream(catalinaHome + versionPropertiesFilename);
            this.versionProperties.load(versionPropertiesStream);
        }
        catch (IOException e) {
            logger.error("Could not read " + versionPropertiesFilename, (Throwable)e);
        }
        finally {
            try {
                if (versionPropertiesStream != null) {
                    versionPropertiesStream.close();
                }
            }
            catch (IOException e) {
                logger.debug("Could not close " + versionPropertiesFilename + " stream", (Throwable)e);
            }
        }
        return this.versionProperties;
    }

    void setRuntimeVersionProperty() {
        String version = this.getVersionProperties().getProperty(PROP_VERSION_KEY);
        if (version != null) {
            System.setProperty(PROP_RUNTIME_VERSION_KEY, version);
        } else {
            logger.error("Property version not available");
        }
    }

    void setRuntimeTypeProperty() {
        String runtimeType = this.getVersionProperties().getProperty(PROP_DISTRIBUTION_KEY);
        if (runtimeType != null) {
            System.setProperty(PROP_RUNTIME_TYPE_KEY, runtimeType);
        } else {
            logger.error("Property distribution.project.name not available");
        }
    }
}

