/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.runtime.kotyo.lifecycle;

import com.sap.cloud.runtime.impl.bridge.ClassloadingBridge;
import com.sap.core.services.accessor.lifecycle.InternalComponentLifecycle;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InternalComponentLifecycleManager
implements LifecycleListener {
    private Logger logger = LoggerFactory.getLogger(InternalComponentLifecycleManager.class);
    private List<InternalComponentLifecycle> internalComponents;

    public void lifecycleEvent(LifecycleEvent event) {
        if ("start".equals(event.getType())) {
            this.startInternalComponents();
        } else if ("stop".equals(event.getType())) {
            this.stopInternalCmponents();
        }
    }

    private void startInternalComponents() {
        this.internalComponents = this.collectInternalComponents();
        for (InternalComponentLifecycle icl : this.internalComponents) {
            try {
                icl.start();
            }
            catch (Exception e) {
                this.logger.error("Exception occurred during start of internal component [" + icl.getClass().getName() + "]." + " Exception: " + e);
            }
        }
    }

    private void stopInternalCmponents() {
        if (this.internalComponents != null) {
            for (InternalComponentLifecycle icl : this.internalComponents) {
                try {
                    icl.stop();
                }
                catch (Exception e) {
                    this.logger.error("Exception occurred during stop of internal component [" + icl.getClass().getName() + "]." + " Exception: " + e);
                }
            }
        }
    }

    private List<InternalComponentLifecycle> collectInternalComponents() {
        ArrayList<InternalComponentLifecycle> collectedComponents = new ArrayList<InternalComponentLifecycle>();
        ServiceLoader<InternalComponentLifecycle> impls = ServiceLoader.load(InternalComponentLifecycle.class, ClassloadingBridge.getImplClassLoader());
        Iterator<InternalComponentLifecycle> implsIterator = impls.iterator();
        while (implsIterator.hasNext()) {
            try {
                InternalComponentLifecycle loadedImpl = implsIterator.next();
                collectedComponents.add(loadedImpl);
            }
            catch (ServiceConfigurationError e) {
                this.logger.error("Cannot load an implementation of " + InternalComponentLifecycle.class.getName(), (Throwable)e);
            }
        }
        if (this.logger.isWarnEnabled() && collectedComponents.isEmpty()) {
            this.logger.warn("Cannot find any implementations for interface: " + InternalComponentLifecycle.class.getName() + ". No internal components will be started/stopped.");
        }
        return collectedComponents;
    }
}

