/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.service.auditlog.extension.impl;

import com.sap.cloud.auditlog.AuditedDataSubject;
import com.sap.cloud.auditlog.AuditedObject;
import com.sap.cloud.auditlog.ConfigurationChangeAuditMessage;
import com.sap.cloud.auditlog.common.AuditLogServer;
import com.sap.cloud.auditlog.exception.NotSupportedMessageTypeException;
import com.sap.cloud.auditlog.extension.AuditLogMessageExtension;
import com.sap.cloud.auditlog.extension.AuditLogMessageExtensionFactory;
import com.sap.cloud.auditlog.extension.ConfigurationChangeAuditMessageExtension;
import com.sap.cloud.auditlog.extension.DataModificationAuditMessageExtension;
import com.sap.cloud.auditlog.extension.ReadAccessAuditMessageExtension;
import com.sap.cloud.auditlog.extension.SecurityEventAuditMessageExtension;
import com.sap.core.service.auditlog.extension.impl.AuditLogMessageExtensionImpl;
import com.sap.core.service.auditlog.extension.mbean.ClientStatusMBeanImpl;
import com.sap.core.service.auditlog.impl.AuditedDataSubjectImpl;
import com.sap.core.service.auditlog.impl.AuditedObjectImpl;
import java.lang.management.ManagementFactory;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuditLogMessageExtensionFactoryImpl
implements AuditLogMessageExtensionFactory {
    private static Logger LOGGER = LoggerFactory.getLogger(AuditLogMessageExtensionFactoryImpl.class);
    public static Class<ConfigurationChangeAuditMessage> ConfigurationMessageClass = ConfigurationChangeAuditMessage.class;
    private static AuditLogServer auditlogServer;
    public static final String AUDITLOG_MBEAN_NAME = "com.sap.cloud.auditlog:name=AuditLogClientStatus,type=AuditLogClientStatus";

    static {
        MBeanServer platformMBeanServer = ManagementFactory.getPlatformMBeanServer();
        try {
            ObjectName objectName = new ObjectName(AUDITLOG_MBEAN_NAME);
            ClientStatusMBeanImpl mBean = new ClientStatusMBeanImpl();
            platformMBeanServer.registerMBean(mBean, objectName);
        }
        catch (InstanceAlreadyExistsException exc) {
            LOGGER.info("MBean com.sap.cloud.auditlog:name=AuditLogClientStatus,type=AuditLogClientStatus is already registered.", (Throwable)exc);
        }
        catch (Exception e) {
            LOGGER.error("Unable to create/register auditlog clien check Mbean: ", (Throwable)e);
        }
    }

    public <T extends AuditLogMessageExtension> T createAuditLogMessageExtension(Class<T> clazz) throws NotSupportedMessageTypeException {
        if (ConfigurationChangeAuditMessageExtension.class.equals(clazz)) {
            AuditLogMessageExtensionImpl message = new AuditLogMessageExtensionImpl();
            message.addSubCategory("configuration");
            return (T)((Object)message);
        }
        if (ReadAccessAuditMessageExtension.class.equals(clazz)) {
            AuditLogMessageExtensionImpl message = new AuditLogMessageExtensionImpl();
            message.addSubCategory("data-access");
            return (T)((Object)message);
        }
        if (SecurityEventAuditMessageExtension.class.equals(clazz)) {
            AuditLogMessageExtensionImpl message = new AuditLogMessageExtensionImpl();
            message.addSubCategory("security-events");
            return (T)((Object)message);
        }
        if (DataModificationAuditMessageExtension.class.equals(clazz)) {
            AuditLogMessageExtensionImpl message = new AuditLogMessageExtensionImpl();
            message.addSubCategory("data-modification");
            return (T)((Object)message);
        }
        if (AuditLogMessageExtension.class.equals(clazz)) {
            AuditLogMessageExtensionImpl message = new AuditLogMessageExtensionImpl();
            return (T)((Object)message);
        }
        throw new NotSupportedMessageTypeException();
    }

    public AuditedObject createAuditedObject() {
        return new AuditedObjectImpl();
    }

    public AuditedDataSubject createAuditedDataSubject() {
        return new AuditedDataSubjectImpl();
    }

    public static void bindAuditlogServer(AuditLogServer auditlogServer) {
        AuditLogMessageExtensionFactoryImpl.auditlogServer = auditlogServer;
        LOGGER.info("Audit log server is binded by osgi framework successfully. All the auditlog messages will be send to auditlog service directly by method invocation, not by S2S communication.");
    }

    public static void unbindAuditlogServer(AuditLogServer auditlogServer) {
        AuditLogMessageExtensionFactoryImpl.auditlogServer = null;
        LOGGER.info("Audit log server is un bind by osgi framework. All the auditlog messages will be send to auditlog service using S2S communication.");
    }

    public static AuditLogServer getAuditlogServer() {
        return auditlogServer;
    }
}

