/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.service.auditlog.extension.impl;

import com.sap.cloud.auditlog.common.AuditLogServer;
import com.sap.cloud.auditlog.exception.AuditLogWriteException;
import com.sap.cloud.auditlog.extension.AuditLogMessageExtension;
import com.sap.cloud.auditlog.extension.ConfigurationChangeAuditMessageExtension;
import com.sap.cloud.auditlog.extension.DataModificationAuditMessageExtension;
import com.sap.cloud.auditlog.extension.ReadAccessAuditMessageExtension;
import com.sap.cloud.auditlog.extension.SecurityEventAuditMessageExtension;
import com.sap.core.service.auditlog.extension.impl.AuditLogMessageExtensionFactoryImpl;
import com.sap.core.service.auditlog.extension.impl.MessageOnBehalfOf;
import com.sap.core.service.auditlog.impl.AuditLogMessageImpl;
import com.sap.core.service.auditlog.impl.Utils;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuditLogMessageExtensionImpl
extends AuditLogMessageImpl
implements AuditLogMessageExtension,
ReadAccessAuditMessageExtension,
DataModificationAuditMessageExtension,
ConfigurationChangeAuditMessageExtension,
SecurityEventAuditMessageExtension {
    private static final String ON_BEHALF_OF = "onBehalfOf";
    private static final String HEADER_ONBEHALFOF_TENANT = "onBehalfOfTenantId";
    private static final String HEADER_ONBEHALFOF_ACCOUNT = "onBehalfOfAccount";
    private static final String HEADER_ONBEHALFOF_VISIBILITY = "onBehalfOfVisible";
    private MessageOnBehalfOf messageOnbehalfof;
    private static Logger logger = LoggerFactory.getLogger(AuditLogMessageExtensionImpl.class);
    private static final String CALLER_IP_ADDRESS = "caller_IP_address";
    private static final String CALLER_HOSTNAME = "caller_hostname";
    private static final String CALLER_USER = "caller_user";
    private static final String CALLER_ACCOUNT = "caller_account";
    private static final String CALLER_APPLICATION = "caller_application";
    private static final String CALLER_COMPONENT = "caller_component";
    private static final String CALLER_TENANT_ID = "caller_tenant_ID";

    public void setOnBehalfOf(boolean visibleToOnBehalfOf, String ipAddress, String hostname, String user, String account, String application, String component, String tenantId) {
        MessageOnBehalfOf message = new MessageOnBehalfOf();
        message.setVisibleToOnbehalfOf(visibleToOnBehalfOf);
        message.setIpAddress(Utils.encodeString((String)ipAddress));
        message.setHostname(Utils.encodeString((String)hostname));
        message.setUser(Utils.encodeString((String)user));
        message.setAccount(Utils.encodeString((String)account));
        message.setApplication(Utils.encodeString((String)application));
        message.setComponent(Utils.encodeString((String)component));
        message.setTenantId(Utils.encodeString((String)tenantId));
        this.messageOnbehalfof = message;
    }

    public void setOnBehalfOf(String ipAddress, String hostname, String user, String account, String application, String component, String tenantId) {
        this.setOnBehalfOf(true, ipAddress, hostname, user, account, application, component, tenantId);
    }

    public void setCaller(String ipAddress, String hostname, String user, String account, String application, String component, String tenantId) {
        this.addCustomAttribute(CALLER_IP_ADDRESS, ipAddress);
        this.addCustomAttribute(CALLER_HOSTNAME, hostname);
        this.addCustomAttribute(CALLER_USER, user);
        this.addCustomAttribute(CALLER_ACCOUNT, account);
        this.addCustomAttribute(CALLER_APPLICATION, application);
        this.addCustomAttribute(CALLER_COMPONENT, component);
        this.addCustomAttribute(CALLER_TENANT_ID, tenantId);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        boolean addPairSeparator = false;
        addPairSeparator = Utils.writeMessagePart((StringBuilder)builder, (boolean)addPairSeparator, (Object)this.messageOnbehalfof, (String)ON_BEHALF_OF);
        String messageStr = super.toString();
        if (messageStr != null && messageStr.length() > 0) {
            if (addPairSeparator) {
                builder.append(",");
            }
            builder.append(messageStr);
        }
        return builder.toString();
    }

    protected Map<String, String> getHeadersForOnbehalfOf() {
        if (this.messageOnbehalfof == null) {
            return null;
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put(HEADER_ONBEHALFOF_TENANT, this.messageOnbehalfof.getTenantId());
        headers.put(HEADER_ONBEHALFOF_ACCOUNT, this.messageOnbehalfof.getAccount());
        headers.put(HEADER_ONBEHALFOF_VISIBILITY, this.messageOnbehalfof.getVisibleToOnBehalfOf());
        return headers;
    }

    protected String ensambleOnbehalfOfMessage() {
        if (this.messageOnbehalfof != null) {
            return this.messageOnbehalfof.toString();
        }
        return null;
    }

    public void log() throws AuditLogWriteException {
        AuditLogServer auditlogServer = AuditLogMessageExtensionFactoryImpl.getAuditlogServer();
        if (auditlogServer == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Auditlog server is null (not injected by osgi framework). This is OK if this is not auditlog service node.");
            }
            super.log();
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug("Auditlog server is available. The message will be send directly by method invocation. S2S will NOT be used in this case.");
            }
            this.invokeSendOnTheServer(auditlogServer);
        }
    }

    private void invokeSendOnTheServer(AuditLogServer auditlogServer) throws AuditLogWriteException {
        String clientsideMetadata = this.ensambleClientSideMetaDataFields();
        String action = this.getVerbAsString();
        String object = this.getObjectAsString();
        String custom = this.getCustomAsString();
        String onbehalfof = this.ensambleOnbehalfOfMessage();
        String onbehalfOfAccount = this.getOnbehalfOfAccount();
        try {
            auditlogServer.sendAuditLogMessage("2", this.category, clientsideMetadata, action, object, custom, onbehalfof, onbehalfOfAccount);
        }
        catch (Exception e) {
            logger.error("Unable to send auditlog message." + this.messageId + " on the auditlog server", (Throwable)e);
            throw new AuditLogWriteException("Unable to send auditlog message.", (Throwable)e);
        }
    }

    private String getOnbehalfOfAccount() {
        if (this.messageOnbehalfof == null) {
            return null;
        }
        if (Boolean.parseBoolean(this.messageOnbehalfof.getVisibleToOnBehalfOf()) && this.messageOnbehalfof.getAccount() != null && this.messageOnbehalfof.getAccount().length() > 0) {
            return this.messageOnbehalfof.getAccount();
        }
        return null;
    }
}

