/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.service.auditlog.extension.mbean;

import com.sap.core.service.auditlog.extension.mbean.ClientStatusMBean;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientStatusMBeanImpl
implements ClientStatusMBean {
    private static final Logger LOG = LoggerFactory.getLogger(ClientStatusMBeanImpl.class);
    private boolean success = false;
    private List<String> failures = new ArrayList<String>();
    private String statusMessage = "OK";

    @Override
    public synchronized void success() {
        this.success = true;
    }

    @Override
    public synchronized void failure(String reason) {
        if (!this.failures.contains(reason)) {
            this.failures.add(reason);
        }
    }

    @Override
    public synchronized String getStatus() {
        this.setStatusMessage();
        this.reset();
        return this.statusMessage;
    }

    private void setStatusMessage() {
        Status status = this.calculateStatus();
        switch (status) {
            case OK: {
                this.statusMessage = this.getOKStatusMessage();
                break;
            }
            case ERROR: {
                this.statusMessage = this.getErrorStatusMessage();
                break;
            }
            default: {
                LOG.debug("Status message will not be updated. Status: " + (Object)((Object)status));
            }
        }
    }

    private Status calculateStatus() {
        if (this.hasFailures()) {
            return Status.ERROR;
        }
        if (this.hasSuccess()) {
            return Status.OK;
        }
        return Status.UNKNOWN;
    }

    private boolean hasFailures() {
        return !this.failures.isEmpty();
    }

    private boolean hasSuccess() {
        return this.success;
    }

    private String getOKStatusMessage() {
        return "OK";
    }

    private String getErrorStatusMessage() {
        StringBuilder statusMessage = new StringBuilder("ERROR -");
        for (String message : this.failures) {
            statusMessage.append(" ");
            statusMessage.append(message);
            statusMessage.append(";");
        }
        return statusMessage.toString();
    }

    private void reset() {
        this.success = false;
        this.failures.clear();
    }

    private static enum Status {
        OK,
        ERROR,
        UNKNOWN;

    }
}

