/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.services.accessor.internal.loader;

import com.sap.core.services.accessor.internal.loader.WebAppBundleClassLoaderDelegateHook;
import com.sap.core.services.accessor.internal.loader.WebAppBundleClassloaderCustomizer;
import com.sap.core.services.accessor.internal.loader.WebAppBundleTrackerCustomizer;
import com.sap.core.services.accessor.internal.naming.ObjectFactoryTracker;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.naming.spi.ObjectFactory;
import org.eclipse.osgi.framework.console.CommandInterpreter;
import org.eclipse.osgi.framework.console.CommandProvider;
import org.osgi.framework.Bundle;

public class ServicesAccessorCommandProvider
implements CommandProvider {
    private static String API_OPTION = "-api";
    private static String IMPL_OPTION = "-impl";
    private static String CLASH_OPTION = "-clash";
    private static String OBJECT_FACTORIES_OPTION = "-factories";
    private static String API_BUNDLE_TYPE = "API";
    private static String IMPL_BUNDLE_TYPE = "Implementation";
    private WebAppBundleTrackerCustomizer webAppBundleTrackerCustomizer;
    private WebAppBundleClassLoaderDelegateHook wabClassLoaderDelegateHook;
    private String bundleType;
    private final Object monitor = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _list_exposed_content(CommandInterpreter ci) {
        Object object = this.monitor;
        synchronized (object) {
            if (this.wabClassLoaderDelegateHook != null) {
                String option = ci.nextArgument();
                if (API_OPTION.equalsIgnoreCase(option)) {
                    this.bundleType = API_BUNDLE_TYPE;
                    this.displayBundles(this.wabClassLoaderDelegateHook.getApiBundles(), ci);
                } else if (IMPL_OPTION.equalsIgnoreCase(option)) {
                    this.bundleType = IMPL_BUNDLE_TYPE;
                    this.displayBundles(this.wabClassLoaderDelegateHook.getImplBundles(), ci);
                } else if (CLASH_OPTION.equalsIgnoreCase(option)) {
                    this.findClashes(ci);
                } else if (OBJECT_FACTORIES_OPTION.equalsIgnoreCase(option)) {
                    this.displayObjectFactories(ci);
                } else {
                    ci.println();
                    ci.println((Object)"Specify -api , -impl, -clash or -factories option");
                }
            }
        }
    }

    private void displayObjectFactories(CommandInterpreter ci) {
        Map<String, List<ObjectFactory>> objectFactories = ObjectFactoryTracker.getObjectFactories();
        if (objectFactories == null || objectFactories.size() == 0) {
            ci.println();
            ci.println((Object)"No ObjectFactory available");
            return;
        }
        for (String referenceType : objectFactories.keySet()) {
            this.printFactoriesForReferenceType(referenceType, objectFactories.get(referenceType), ci);
        }
    }

    private void printFactoriesForReferenceType(String referenceType, List<ObjectFactory> factories, CommandInterpreter ci) {
        ci.println();
        ci.println((Object)("Object factories for reference type " + referenceType));
        ci.println();
        for (ObjectFactory objectFactory : factories) {
            ci.println((Object)objectFactory.getClass().toString());
        }
    }

    private void displayBundles(Set<Bundle> bundles, CommandInterpreter ci) {
        if (bundles.size() == 0) {
            ci.println((Object)("No service " + this.bundleType + " bundles available"));
            return;
        }
        ci.println();
        ci.print((Object)"ID");
        ci.print((Object)"\t");
        ci.print((Object)"Bundle name");
        ci.println();
        for (Bundle bundle : bundles) {
            ci.print((Object)bundle.getBundleId());
            ci.print((Object)"\t");
            ci.print((Object)(String.valueOf(bundle.getSymbolicName()) + "_" + bundle.getVersion()));
            ci.println();
        }
    }

    private void findClashes(CommandInterpreter ci) {
        Map<String, List<Bundle>> bundlesWithSameBSNMap = this.webAppBundleTrackerCustomizer.getBundlesWithSameBSNMap();
        if (bundlesWithSameBSNMap == null || bundlesWithSameBSNMap.size() == 0) {
            ci.println((Object)"There are no clashes");
            return;
        }
        Set<Bundle> apiBundles = this.wabClassLoaderDelegateHook.getApiBundles();
        this.handleClashes(apiBundles, bundlesWithSameBSNMap, ci, API_BUNDLE_TYPE);
        Set<Bundle> implBundles = this.wabClassLoaderDelegateHook.getImplBundles();
        this.handleClashes(implBundles, bundlesWithSameBSNMap, ci, IMPL_BUNDLE_TYPE);
    }

    private void handleClashes(Set<Bundle> bundles, Map<String, List<Bundle>> bundlesWithSameBSNMap, CommandInterpreter ci, String type) {
        ci.println((Object)("Clashing " + type + "s:"));
        ci.println();
        for (Bundle bundle : bundles) {
            List<Bundle> bundlesWithSameBSN = bundlesWithSameBSNMap.get(bundle.getSymbolicName());
            if (bundlesWithSameBSN.size() <= 1) continue;
            this.printClashing(bundlesWithSameBSN, bundle, ci);
        }
    }

    private void printClashing(List<Bundle> bundlesWithSameBSN, Bundle chosenBundle, CommandInterpreter ci) {
        ci.println((Object)("Clashing bundles for BSN " + chosenBundle.getSymbolicName() + ":"));
        for (Bundle bundle : bundlesWithSameBSN) {
            ci.println((Object)(String.valueOf(bundle.getSymbolicName()) + "_" + bundle.getVersion()));
        }
        ci.println();
        ci.println((Object)("Chosen bundle: " + chosenBundle.getSymbolicName() + "_" + chosenBundle.getVersion()));
    }

    public void bindCustomizer(WebAppBundleClassloaderCustomizer customizer) {
        this.webAppBundleTrackerCustomizer = customizer.getWebAppBundleTrackerCustomizer();
        this.wabClassLoaderDelegateHook = customizer.getWebAppBundleClassLoaderDelegateHook();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unbindCustomizer(WebAppBundleClassloaderCustomizer customizer) {
        Object object = this.monitor;
        synchronized (object) {
            this.wabClassLoaderDelegateHook = null;
            this.webAppBundleTrackerCustomizer = null;
        }
    }

    public String getHelp() {
        String help = "---Services accessor commands---\r\n\tlist_exposed_content <option> - display information about apis, which will be transparently added to applications, apis' implementations and JNDI consumption of services\r\n\t\tOptions:\r\n\t\t-api - display all API bundles\r\n\t\t-impl - display all Implementation bundles\r\n\t\t-clash - display all clashing API/Implementation bundles and which one is chosen\r\n\t\t-factories - display all discovered object factories along with the reference types\r\n";
        return help;
    }
}

